package org.gridvise.coherence.cache.scheduling;

import java.util.Collections;

import org.apache.log4j.Logger;
import org.gridvise.coherence.cache.listener.AbstractBackingMapListener;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.MapEvent;

public class SchedulerBackingMapListener extends
		AbstractBackingMapListener<JobKey, ScheduledJob> {

	private static final Logger LOG = Logger
			.getLogger(SchedulerBackingMapListener.class);

	private Scheduler scheduler;

	public SchedulerBackingMapListener(BackingMapManagerContext context) {
		super(context);
		try {
	        scheduler = StdSchedulerFactory.getDefaultScheduler();
	        scheduler.start();
			LOG.info("started scheduler");
		} catch (SchedulerException e) {
			LOG.error("Failed to initialize Quartz scheduler", e);
		}
	}

	@Override
	public void entryInserted(MapEvent event) {
		ScheduledJob sj = getNewValue(event);
		JobDetail job = sj.getJob();

		try {
			scheduler.scheduleJob(job, sj.getTriggers().get(0));
//			scheduler.scheduleJobs(
//					Collections.singletonMap(job, sj.getTriggers()), false);
			LOG.info("Scheduled job " + job);
		} catch (SchedulerException e) {
			LOG.error("Failed to schedule job " + job, e);
		}
	}

	@Override
	public void entryUpdated(MapEvent event) {
		ScheduledJob sj = getNewValue(event);
		JobDetail job = sj.getJob();

		try {
			scheduler.scheduleJobs(
					Collections.singletonMap(job, sj.getTriggers()), true);
			LOG.info("Rescheduled job " + job);
		} catch (SchedulerException e) {
			LOG.error("Failed to reschedule job " + job, e);
		}
	}

	@Override
	public void entryDeleted(MapEvent event) {
		ScheduledJob sj = getOldValue(event);
		JobDetail job = sj.getJob();

		try {
			scheduler.deleteJob(job.getKey());
			LOG.info("Unscheduled job " + job);
		} catch (SchedulerException e) {
			LOG.error("Failed to unschedule job " + job, e);
		}
	}
}
