/*
 * Decompiled with CFR 0.152.
 */
package org.gridvise.coherence.cache.entity;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.DistinctValues;
import com.tangosol.util.aggregator.GroupAggregator;
import com.tangosol.util.filter.PresentFilter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.gridvise.coherence.cache.entity.ICache;
import org.gridvise.coherence.cache.entity.aggregator.DistinctSetValuesAggregator;

public abstract class AbstractCache<K, V>
implements ICache<K, V> {
    private static final Logger LOG = Logger.getLogger(AbstractCache.class);
    protected static final Filter PRESENT_FILTER = new PresentFilter();
    private NamedCache namedCache;
    private boolean indexAdded = false;

    public abstract String getCacheName();

    protected abstract void addIndexes(NamedCache var1);

    @Override
    public void addIndex(ValueExtractor valueExtractor) {
        this.getCache().addIndex(valueExtractor, false, null);
    }

    @Override
    public void addMapListener(MapListener mapListener) {
        this.getCache().addMapListener(mapListener);
    }

    @Override
    public void addMapListener(MapListener mapListener, Filter filter, boolean lite) {
        this.getCache().addMapListener(mapListener, filter, lite);
    }

    @Override
    public void addMapListener(MapListener mapListener, K key, boolean lite) {
        this.getCache().addMapListener(mapListener, key, lite);
    }

    @Override
    public void addMapListener(MapListener mapListener, Filter filter) {
        this.addMapListener(mapListener, filter, false);
    }

    @Override
    public void addMapListener(MapListener mapListener, K key) {
        this.addMapListener(mapListener, key, false);
    }

    @Override
    public void removeMapListener(MapListener mapListener) {
        this.getCache().removeMapListener(mapListener);
    }

    @Override
    public void removeMapListener(MapListener mapListener, K key) {
        this.getCache().removeMapListener(mapListener, key);
    }

    @Override
    public void removeMapListener(MapListener mapListener, Filter filter) {
        this.removeMapListener(mapListener, filter);
    }

    @Override
    public void remove(Collection<K> keys) {
        LOG.info((Object)("removing " + keys.size() + " from " + this.getCacheName()));
        NamedCache cache = this.getCache();
        for (K key : keys) {
            cache.remove(key);
        }
    }

    @Override
    public void remove(K key) {
        NamedCache cache = this.getCache();
        cache.remove(key);
    }

    @Override
    public void remove(Filter filter) {
        Collection keysToBeRemoved = this.keySet(filter);
        this.remove((K)keysToBeRemoved);
    }

    public void clearCache() {
        LOG.info((Object)("Clearing cache " + this.getCacheName()));
        this.getCache().clear();
    }

    @Override
    public Set<K> keySet(Filter filter) {
        return this.getCache().keySet(filter);
    }

    @Override
    public Collection<Map.Entry<K, V>> entrySet(Filter filter) {
        return this.getCache().entrySet();
    }

    @Override
    public Map<K, V> values(Filter filter) {
        Set keys = this.getCache().keySet(filter);
        return this.getCache().getAll((Collection)keys);
    }

    @Override
    public Collection<V> values() {
        return this.getCache().values();
    }

    @Override
    public void clear() {
        this.getCache().clear();
    }

    @Override
    public int size() {
        return this.getCache().size();
    }

    @Override
    public NamedCache getCache() {
        if (this.namedCache == null) {
            this.namedCache = CacheFactory.getCache((String)this.getCacheName());
        }
        if (!this.indexAdded) {
            this.addIndexes(this.namedCache);
            this.indexAdded = true;
        }
        return this.namedCache;
    }

    @Override
    public V get(K key) {
        return (V)this.getCache().get(key);
    }

    @Override
    public Map<K, V> getAll(Collection<K> keys) {
        return this.getCache().getAll(keys);
    }

    @Override
    public void put(K key, V value) {
        this.getCache().put(key, value);
    }

    @Override
    public void putAll(Map<K, V> map) {
        this.getCache().putAll(map);
    }

    @Override
    public <E> Collection<E> distictValues(ValueExtractor valueExtractor) {
        Filter f = null;
        return (Collection)this.getCache().aggregate(f, (InvocableMap.EntryAggregator)new DistinctValues(valueExtractor));
    }

    @Override
    public <E> Collection<E> distictValues(Filter filter, Enum<?> extractMethodName) {
        return (Collection)this.getCache().aggregate(filter, (InvocableMap.EntryAggregator)new DistinctValues(extractMethodName.toString()));
    }

    @Override
    public <E> Collection<E> distictValues(Filter filter, ValueExtractor valueExtractor) {
        return (Collection)this.getCache().aggregate(filter, (InvocableMap.EntryAggregator)new DistinctValues(valueExtractor));
    }

    @Override
    public <E> Collection<E> distictSetValues(Filter filter, Enum<?> setExtractMethodName) {
        return (Collection)this.getCache().aggregate(filter, (InvocableMap.EntryAggregator)new DistinctSetValuesAggregator(setExtractMethodName.toString()));
    }

    public <E> Collection<E> distictSetValues(Filter filter, ValueExtractor valueExtractor) {
        return (Collection)this.getCache().aggregate(filter, (InvocableMap.EntryAggregator)new DistinctSetValuesAggregator(valueExtractor));
    }

    @Override
    public <E> Collection<E> distictValues(Collection<K> keys, Enum<?> extractMethodName) {
        return (Collection)this.getCache().aggregate(keys, (InvocableMap.EntryAggregator)new DistinctValues(extractMethodName.toString()));
    }

    @Override
    public <E> Collection<E> distictValues(Collection<K> keys, String extractMethodName) {
        return (Collection)this.getCache().aggregate(keys, (InvocableMap.EntryAggregator)new DistinctValues(extractMethodName.toString()));
    }

    @Override
    public <E> Collection<E> distictSetValues(Collection<K> keys, Enum<?> setExtractMethodName) {
        return (Collection)this.getCache().aggregate(keys, (InvocableMap.EntryAggregator)new DistinctSetValuesAggregator(setExtractMethodName.toString()));
    }

    @Override
    public <G, E> Map<G, Collection<E>> distictValues(Filter filter, Enum<?> extractMethodName, Enum<?> groupByExtractMethodName) {
        GroupAggregator groupAggregator = this.getDistinctGroupByAggregator(extractMethodName, groupByExtractMethodName);
        return (Map)this.getCache().aggregate(filter, (InvocableMap.EntryAggregator)groupAggregator);
    }

    @Override
    public <G, E> Map<G, Collection<E>> distictSetValues(Filter filter, Enum<?> setExtractMethodName, Enum<?> groupByExtractMethodName) {
        GroupAggregator groupSetAggregator = this.getDistinctSetGroupByAggregator(setExtractMethodName, groupByExtractMethodName);
        return (Map)this.getCache().aggregate(filter, (InvocableMap.EntryAggregator)groupSetAggregator);
    }

    @Override
    public <G, E> Map<G, Collection<E>> distictValues(Collection<K> keys, Enum<?> extractMethodName, Enum<?> groupByExtractMethodName) {
        GroupAggregator groupAggregator = this.getDistinctGroupByAggregator(extractMethodName, groupByExtractMethodName);
        return (Map)this.getCache().aggregate(keys, (InvocableMap.EntryAggregator)groupAggregator);
    }

    public <G, E> Map<G, Collection<E>> distictSetValues(Collection<K> keys, Enum<?> setExtractMethodName, Enum<?> groupByExtractMethodName) {
        GroupAggregator groupSetAggregator = this.getDistinctSetGroupByAggregator(setExtractMethodName, groupByExtractMethodName);
        return (Map)this.getCache().aggregate(keys, (InvocableMap.EntryAggregator)groupSetAggregator);
    }

    private GroupAggregator getDistinctGroupByAggregator(Enum<?> extractMethodName, Enum<?> groupByExtractMethodName) {
        return GroupAggregator.createInstance((String)groupByExtractMethodName.toString(), (InvocableMap.EntryAggregator)new DistinctValues(extractMethodName.toString()));
    }

    private GroupAggregator getDistinctSetGroupByAggregator(Enum<?> extractMethodName, Enum<?> groupByExtractMethodName) {
        return GroupAggregator.createInstance((String)groupByExtractMethodName.toString(), (InvocableMap.EntryAggregator)new DistinctSetValuesAggregator(extractMethodName.toString()));
    }

    protected void addIndex(ValueExtractor valueExtractor, NamedCache cache) {
        this.getCache().addIndex(valueExtractor, false, null);
    }

    @Override
    public Object invoke(K key, InvocableMap.EntryProcessor entryprocessor) {
        return this.getCache().invoke(key, entryprocessor);
    }

    @Override
    public Map<K, ?> invokeAll(Collection<K> keys, InvocableMap.EntryProcessor entryprocessor) {
        return this.getCache().invokeAll(keys, entryprocessor);
    }

    @Override
    public Object aggregate(Collection<K> keys, InvocableMap.EntryAggregator aggregator) {
        return this.getCache().aggregate(keys, aggregator);
    }

    @Override
    public Object aggregate(Filter filter, InvocableMap.EntryAggregator aggregator) {
        return this.getCache().aggregate(filter, aggregator);
    }
}

