package org.gridvise.coherence.cache.invocation;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.InvocationService;
import org.apache.log4j.Logger;

import java.util.Collection;
import java.util.Set;

public abstract class AbstractExtendInvocationService<R> {
	
	private InvocationService is = (InvocationService) CacheFactory.getService(this.getName());
    private static final Logger LOG = Logger.getLogger(AbstractExtendInvocationService.class);

	public Collection<R> queryOnAllMembers(AbstractRemoteTask<R> task){
        return (Collection<R>)is.query(new ExtendInvocable(task), null).values();
	}
	
	public abstract String getName();
}
