package org.gridvise.coherence.cache.entity;

import java.util.Collection;
import java.util.Date;
import java.util.SortedSet;

import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;

public interface IDateSensitiveCache<K, V> extends ICache<K, V> {

    void evictDaysOlderOrEquals(Date effectiveDate);

    void evictDay(Date effectiveDate);

    ValueExtractor getEffectiveDateExtractor();

    Filter getEffectiveDateFilter(Date effectiveDate);

    Collection<V> getValuesForDate(Date effectiveDate);

    Collection<K> getKeysForDate(Date effectiveDate);

    Date getLatestEffectiveDate();

    Date getEarliestEffectiveDate();

    SortedSet<Date> getSortedEffectiveDates();

    Collection<Date> getEffectiveDates();

    /**
     * Returns the a set of distinct values returned form the
     * 'extractMethodName'-method on objects only for the given date.
     * @param filter
     * @param extractMethodName
     * @return
     */
    public <E> Collection<E> distictValuesForDate(Date effectiveDate, Enum<?> extractMethodName);

    /**
     * Returns the a set of distinct values returned form the
     * 'extractMethodName'-method which it self extracts a collection of objects
     * only for the given date.
     * @param filter
     * @param extractMethodName
     * @return
     */
    public <E> Collection<E> distictSetValuesForDate(Date effectiveDate, Enum<?> setExtractMethodName);

}
