package org.gridvise.coherence.cache.invocation;

import com.tangosol.net.Invocable;
import com.tangosol.net.InvocationService;
import org.apache.log4j.Logger;

import java.io.Serializable;

public class ExtendInvocable implements Invocable, Serializable {

    private Invocable invocable;
    private InvocationService invocationService;
    private Object result;
    private static final Logger LOG = Logger
            .getLogger(AbstractRemoteTask.class);

    public ExtendInvocable(Invocable invocable){
        this.invocable = invocable;
    }

    @Override
    public Object getResult() {
        return result;
    }

    @Override
    public void init(InvocationService invocationService) {
        LOG.info(this + " initialized with " + invocationService.getInfo());
        this.invocationService = invocationService;

    }

    @Override
    public void run() {
        this.result = invocationService.query(this.invocable, null);
    }
}
