package org.gridvise.coherence.cache.invocation;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocationService;
import org.apache.log4j.Logger;

import java.io.Serializable;

public class ExtendInvocable implements Invocable, Serializable {

    private Invocable invocable;
    private String invocationServiceName;
    private InvocationService invocationService;
    private Object result;
    private static final Logger LOG = Logger
            .getLogger(AbstractRemoteTask.class);

    public ExtendInvocable(String targetInvocationServiceName, Invocable invocable){
        this.invocationServiceName = targetInvocationServiceName;
        this.invocable = invocable;
    }

    @Override
    public Object getResult() {
        return result;
    }

    @Override
    public void init(InvocationService invocationService) {
        LOG.info(this + " initialized with " + invocationService.getInfo());
        this.invocationService = (InvocationService) CacheFactory.getService(this.invocationServiceName);
    }

    @Override
    public void run() {
        this.result = invocationService.query(this.invocable, null);
    }
}
