package org.gridvise.coherence.cache.entity;

import java.util.Collection;
import java.util.Map;
import java.util.Map.Entry;

import com.tangosol.net.NamedCache;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap.EntryAggregator;
import com.tangosol.util.InvocableMap.EntryProcessor;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;

public interface ICache<K, V> {

	NamedCache getCache();

	Collection<K> keySet(Filter filter);

	Collection<Entry<K, V>> entrySet(Filter filter);

	Map<K, V> values(Filter filter);

	Collection<V> values();

	void clear();

	int size();

	void remove(Collection<K> keys);

	void remove(K key);

	void remove(Filter filter);

	V get(K key);

	Map<K, V> getAll(Collection<K> keys);

	void put(K key, V value);

	void putAll(Map<K, V> map);

	Object invoke(K key, EntryProcessor invocable);

	Map<K, ?> invokeAll(Collection<K> keys, EntryProcessor invocable);

	Object aggregate(Collection<K> keys, EntryAggregator aggregator);

	Object aggregate(Filter filter, EntryAggregator aggregator);

	/**
	 * Returns the a set of distinct values returned form the extractor for all
	 * entries in the cache
	 * 
	 * @param filter
	 * @param extractMethodName
	 * @return
	 */
	public <E> Collection<E> distictValues(ValueExtractor valueExtractor);

	/**
	 * Returns the a set of distinct values returned form the
	 * 'extractMethodName'-method on objects addressed by the filter.
	 * 
	 * @param filter
	 * @param extractMethodName
	 * @return
	 */
	public <E> Collection<E> distictValues(Filter filter,
			Enum<?> extractMethodName);

	/**
	 * Returns the a set of distinct values returned form the valueExtractor
	 * executed on objects addressed by the filter.
	 * 
	 * @param filter
	 * @param extractMethodName
	 * @return
	 */
	public <E> Collection<E> distictValues(Filter filter,
			ValueExtractor valueExtractor);

	/**
	 * Returns the a set of distinct values returned form the
	 * 'extractMethodName'-method which it self extracts a collection of objects
	 * addressed by the filter.
	 * 
	 * @param <E>
	 * @param filter
	 * @param extractMethodName
	 * @return
	 */
	public <E> Collection<E> distictSetValues(Filter filter,
			Enum<?> setExtractMethodName);

	/**
	 * Returns the a set of distinct values returned form the
	 * 'extractMethodName'-method on objects addressed by the keys.
	 * 
	 * @param filter
	 * @param extractMethodName
	 * @return
	 */
	public <E> Collection<E> distictValues(Collection<K> keys,
			Enum<?> extractMethodName);

	<E> Collection<E> distictValues(Collection<K> keys, String extractMethodName);

	/**
	 * Returns the a set of distinct values returned form the
	 * 'extractMethodName'-method which it self extracts a collection of objects
	 * addressed by the keys.
	 * 
	 * @param filter
	 * @param extractMethodName
	 * @return
	 */
	public <E> Collection<E> distictSetValues(Collection<K> keys,
			Enum<?> setExtractMethodName);

	public <G, E> Map<G, Collection<E>> distictValues(Filter filter,
			Enum<?> extractMethodName, Enum<?> groupByExtractMethodName);

	public <G, E> Map<G, Collection<E>> distictSetValues(Filter filter,
			Enum<?> setExtractMethodName, Enum<?> groupByExtractMethodName);

	public <G, E> Map<G, Collection<E>> distictValues(Collection<K> keys,
			Enum<?> extractMethodName, Enum<?> groupByExtractMethodName);

	public void addIndex(ValueExtractor valueExtractor);

	public void addMapListener(MapListener listener);

	public void addMapListener(MapListener mapListener, Filter filter,
			boolean lightweight);

	public void addMapListener(MapListener mapListener, Filter filter);

	public void addMapListener(MapListener mapListener, K key, boolean lite);

	public void addMapListener(MapListener mapListener, K key);

	public void removeMapListener(MapListener listener);
	public void removeMapListener(MapListener listener, K key);
	public void removeMapListener(MapListener mapListener, Filter filter);
}
