package org.gridvise.coherence.cache.invocation;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import org.apache.log4j.Logger;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public abstract class AbstractInvocationService {
	
	private InvocationService is = (InvocationService) CacheFactory.getService(this.getName());
    private static final Logger LOG = Logger.getLogger(AbstractInvocationService.class);

	public <R> Collection<R> queryOnAllMembers(AbstractRemoteTask<? extends R> task){
        return (Collection<R>)is.query(task, null).values();
	}

    public <R> Collection<R> queryOnAllMembers(String targetInvocationService, AbstractRemoteTask<? extends R> task){
        Collection<R> results = new HashSet<R>();
        Map<Member, Map<Member, R>> r = is.query(new ExtendInvocable(targetInvocationService, task), null);
        for(Map<Member, R> m : r.values()){
            results.addAll(m.values());
        }
        return results;
    }

    public abstract String getName();
}
