package org.gridvise.coherence.cache.entity.aggregator;


import java.util.Collection;

import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.LiteSet;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.AbstractAggregator;

public class DistinctSetValuesAggregator extends AbstractAggregator implements PortableObject {

    private static final long serialVersionUID = -2526320882176890443L;

    @SuppressWarnings("rawtypes")
    private transient Collection localCollectionOfV = new LiteSet();

    public DistinctSetValuesAggregator() {
        // serialization
    }

    public DistinctSetValuesAggregator(String methodName) {
        super(methodName);
    }

    public DistinctSetValuesAggregator(ValueExtractor valueExtractor) {
        super(valueExtractor);
    }

    @Override
    protected Object finalizeResult(boolean fFinal) {
        return this.localCollectionOfV;
    }

    @Override
    protected void init(boolean arg0) {

    }

    @SuppressWarnings("unchecked")
    @Override
    protected void process(Object o, boolean fFinal) {
        if (o != null && o instanceof Collection) {
            @SuppressWarnings("rawtypes")
            Collection colPartial = (Collection) o;
            localCollectionOfV.addAll(colPartial);
        }
    }

}
