package org.gridvise.coherence.cache.invocation;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocationService;

public abstract class AbstractRemoteTask<R> implements Invocable,
		PortableObject {
	
	enum PofIndex {
		RESULT, PARAMETERS
	}

	private static final long serialVersionUID = -2605443704130754923L;

	private static final Logger LOG = Logger
			.getLogger(AbstractRemoteTask.class);

	private R result;
	private Map<String, Serializable> parameters = new HashMap<String, Serializable>();

	public abstract R execute();

	@Override
	public Object getResult() {
		return result;
	}

	@Override
	public void init(InvocationService invocationService) {
		LOG.info(this + " initialized with " + invocationService.getInfo());
	}

	@Override
	public void run() {
		this.result = this.execute();
	}
	
	protected void addParameter(String name, Serializable value){
		this.parameters.put(name, value);
	}

	protected <P> P getParameter(String name){
		return (P)this.parameters.get(name);
	}

	@SuppressWarnings("unchecked")
	@Override
	public void readExternal(PofReader pofReader) throws IOException {
		this.result = (R)pofReader.readObject(PofIndex.RESULT.ordinal());
		pofReader.readMap(PofIndex.PARAMETERS.ordinal(), this.parameters);
	}

	@Override
	public void writeExternal(PofWriter pofWriter) throws IOException {
		pofWriter.writeObject(PofIndex.RESULT.ordinal(), this.result);
		pofWriter.writeMap(PofIndex.PARAMETERS.ordinal(), this.parameters);
	}

}
