/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer;

import org.gstreamer.Fraction;
import org.gstreamer.lowlevel.GValueAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstValueAPI;

public class Range {
    private static final GstValueAPI gst = GstNative.load(GstValueAPI.class);
    private GValueAPI.GValue value;

    Range(GValueAPI.GValue value) {
        this.value = value;
    }

    public Fraction getMinFraction() {
        GValueAPI.GValue frMin = gst.gst_value_get_fraction_range_min(this.value);
        int num = gst.gst_value_get_fraction_numerator(frMin);
        int denom = gst.gst_value_get_fraction_denominator(frMin);
        return new Fraction(num, denom);
    }

    public Fraction getMaxFraction() {
        GValueAPI.GValue frMax = gst.gst_value_get_fraction_range_max(this.value);
        int num = gst.gst_value_get_fraction_numerator(frMax);
        int denom = gst.gst_value_get_fraction_denominator(frMax);
        return new Fraction(num, denom);
    }

    public double getMinDouble() {
        return gst.gst_value_get_double_range_min(this.value);
    }

    public double getMaxDouble() {
        return gst.gst_value_get_double_range_max(this.value);
    }

    public int getMinInt() {
        return gst.gst_value_get_int_range_min(this.value);
    }

    public int getMaxInt() {
        return gst.gst_value_get_int_range_max(this.value);
    }
}

