/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import com.sun.jna.Pointer;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Pipeline;
import org.gstreamer.StreamInfo;
import org.gstreamer.lowlevel.GlibAPI;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayBin
extends Pipeline {
    public PlayBin(String name) {
        this(PlayBin.makeRawElement("playbin", name));
    }

    public PlayBin(String name, URI uri) {
        this(name);
        this.setURI(uri);
    }

    public PlayBin(NativeObject.Initializer init) {
        super(init);
    }

    public void setInputFile(File file) {
        this.setURI(file.toURI());
    }

    public void setURI(URI uri) {
        this.set("uri", uri);
    }

    public void setAudioSink(Element element) {
        this.setElement("audio-sink", element);
    }

    public void setVideoSink(Element element) {
        this.setElement("video-sink", element);
    }

    public void setVisualization(Element element) {
        this.setElement("vis-plugin", element);
    }

    private void setElement(String key, Element element) {
        if (element == null) {
            element = ElementFactory.make("fakesink", "fake-" + key);
        }
        this.set(key, element);
    }

    public void setVolumePercent(int percent) {
        this.setVolume(Math.max(Math.min((double)percent, 100.0), 0.0) / 100.0);
    }

    public int getVolumePercent() {
        return (int)(this.getVolume() * 100.0 + 0.5);
    }

    public void setVolume(double volume) {
        this.set("volume", volume);
    }

    public double getVolume() {
        return ((Number)this.get("volume")).doubleValue();
    }

    public List<StreamInfo> getStreamInfo() {
        Pointer ptr = this.getPointer("stream-info");
        if (ptr != null) {
            GlibAPI.GList glist = GlibAPI.GList.valueOf(ptr);
            if (glist == null) {
                return null;
            }
            ArrayList<StreamInfo> list = new ArrayList<StreamInfo>();
            for (GlibAPI.GList next = glist; next != null; next = next.next()) {
                if (next.data == null) continue;
                list.add(new StreamInfo(next.data, true, true));
            }
            return list;
        }
        return null;
    }
}

