/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import java.nio.IntBuffer;
import org.gstreamer.Bin;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GhostPad;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.Structure;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.lowlevel.GstBinAPI;
import org.gstreamer.lowlevel.GstNative;

public class RGBDataSink
extends Bin {
    private static final GstBinAPI gst = GstNative.load(GstBinAPI.class);
    private boolean passDirectBuffer = false;
    private final Listener listener;
    private final BaseSink videosink;

    public RGBDataSink(String name, Listener listener) {
        super(RGBDataSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        this.videosink = (BaseSink)ElementFactory.make("fakesink", "VideoSink");
        this.videosink.set("signal-handoffs", true);
        this.videosink.set("sync", true);
        this.videosink.connect(new VideoHandoffListener());
        Element conv = ElementFactory.make("ffmpegcolorspace", "ColorConverter");
        Element videofilter = ElementFactory.make("capsfilter", "ColorFilter");
        videofilter.setCaps(new Caps("video/x-raw-rgb, bpp=32, depth=24"));
        this.addMany(conv, videofilter, this.videosink);
        Element.linkMany(conv, videofilter, this.videosink);
        this.addPad(new GhostPad("sink", conv.getStaticPad("sink")));
    }

    public RGBDataSink(String name, Pipeline pipeline, Listener listener) {
        super(RGBDataSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        this.videosink = (BaseSink)pipeline.getElementByName("VideoSink");
        this.videosink.set("signal-handoffs", true);
        this.videosink.set("sync", true);
        this.videosink.connect(new VideoHandoffListener());
    }

    public void setPassDirectBuffer(boolean passThru) {
        this.passDirectBuffer = passThru;
    }

    public BaseSink getSinkElement() {
        return this.videosink;
    }

    class VideoHandoffListener
    implements Element.HANDOFF {
        VideoHandoffListener() {
        }

        public void handoff(Element element, Buffer buffer, Pad pad) {
            IntBuffer rgb;
            Caps caps = buffer.getCaps();
            Structure struct = caps.getStructure(0);
            int width = struct.getInteger("width");
            int height = struct.getInteger("height");
            if (width < 1 || height < 1) {
                return;
            }
            if (RGBDataSink.this.passDirectBuffer) {
                rgb = buffer.getByteBuffer().asIntBuffer();
            } else {
                rgb = IntBuffer.allocate(width * height);
                rgb.put(buffer.getByteBuffer().asIntBuffer()).flip();
            }
            RGBDataSink.this.listener.rgbFrame(width, height, rgb);
            buffer.dispose();
        }
    }

    public static interface Listener {
        public void rgbFrame(int var1, int var2, IntBuffer var3);
    }
}

