/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.gstreamer.Bin;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GhostPad;
import org.gstreamer.Gst;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.elements.PlayBin;

public class AudioPanorama {
    private static final int PERIOD = 1000;

    public static void main(String[] args) {
        Pipeline pipe;
        args = Gst.init("AudioPanorama", args);
        PanoramaSink sink = new PanoramaSink("panorama sink");
        if (args.length > 0) {
            PlayBin playbin = new PlayBin("AudioPanorama");
            playbin.setInputFile(new File(args[0]));
            playbin.setAudioSink(sink);
            pipe = playbin;
        } else {
            pipe = new Pipeline("AudioPanorama");
            Element src = ElementFactory.make("audiotestsrc", "src");
            src.set("wave", 2);
            Element convert = ElementFactory.make("audioconvert", "convert");
            pipe.addMany(src, convert, sink);
            Element.linkMany(src, convert, sink);
        }
        Gst.getScheduledExecutorService().scheduleAtFixedRate(new Panner(sink), 100L, 10L, TimeUnit.MILLISECONDS);
        pipe.setState(State.PLAYING);
        Gst.main();
        pipe.setState(State.NULL);
    }

    private static final class Panner
    implements Runnable {
        private float pan = -1.0f;
        private float incr = 0.01f;
        private final PanoramaSink sink;

        private Panner(PanoramaSink sink) {
            this.sink = sink;
        }

        public void run() {
            this.sink.setPanorama(this.pan);
            this.pan += this.incr;
            if (this.pan > 1.0f || this.pan < -1.0f) {
                this.incr = 0.0f - this.incr;
                this.pan += this.incr;
            }
        }
    }

    private static final class PanoramaSink
    extends Bin {
        private final Element audiopanorama = ElementFactory.make("audiopanorama", "panorama");
        private final Element convert = ElementFactory.make("audioconvert", "convert");
        private final Element sink = ElementFactory.make("autoaudiosink", "audiosink");

        public PanoramaSink(String name) {
            super(name);
            this.addMany(this.audiopanorama, this.convert, this.sink);
            PanoramaSink.linkMany(this.audiopanorama, this.convert, this.sink);
            this.addPad(new GhostPad("sink", this.audiopanorama.getStaticPad("sink")));
        }

        public void setPanorama(float pan) {
            this.audiopanorama.set("panorama", Float.valueOf(pan));
        }

        public float getPanorama() {
            return ((Number)this.audiopanorama.get("panorama")).floatValue();
        }
    }
}

