/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.example;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Gst;
import org.gstreamer.Pipeline;
import org.gstreamer.State;
import org.gstreamer.swing.VideoComponent;

public class VideoTest {
    private static Pipeline pipe;

    public static void main(String[] args) {
        System.setProperty("apple.awt.graphics.UseQuartz", "false");
        args = Gst.init("SwingVideoTest", args);
        pipe = new Pipeline("pipeline");
        final Element videosrc = ElementFactory.make("videotestsrc", "source");
        final Element videofilter = ElementFactory.make("capsfilter", "flt");
        videofilter.setCaps(Caps.fromString("video/x-raw-yuv, width=720, height=576, bpp=32, depth=32, framerate=25/1"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VideoComponent videoComponent = new VideoComponent();
                Element videosink = videoComponent.getElement();
                pipe.addMany(videosrc, videofilter, videosink);
                Element.linkMany(videosrc, videofilter, videosink);
                JFrame frame = new JFrame("Swing Video Test");
                frame.setDefaultCloseOperation(3);
                frame.add((Component)videoComponent, "Center");
                videoComponent.setPreferredSize(new Dimension(720, 576));
                frame.pack();
                frame.setVisible(true);
                pipe.setState(State.PLAYING);
            }
        });
    }
}

