/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import com.sun.jna.Library;
import com.sun.jna.Pointer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.gstreamer.Bin;
import org.gstreamer.Buffer;
import org.gstreamer.Bus;
import org.gstreamer.Clock;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.Event;
import org.gstreamer.GhostPad;
import org.gstreamer.Message;
import org.gstreamer.Pad;
import org.gstreamer.PadTemplate;
import org.gstreamer.Pipeline;
import org.gstreamer.Plugin;
import org.gstreamer.PluginFeature;
import org.gstreamer.Query;
import org.gstreamer.Registry;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.elements.BaseSrc;
import org.gstreamer.elements.TypeFind;
import org.gstreamer.interfaces.ColorBalanceChannel;
import org.gstreamer.interfaces.MixerTrack;
import org.gstreamer.interfaces.TunerChannel;
import org.gstreamer.interfaces.TunerNorm;
import org.gstreamer.lowlevel.BaseAPI;
import org.gstreamer.lowlevel.GObjectAPI;
import org.gstreamer.lowlevel.GType;
import org.gstreamer.lowlevel.GstColorBalanceAPI;
import org.gstreamer.lowlevel.GstMixerAPI;
import org.gstreamer.lowlevel.GstNative;
import org.gstreamer.lowlevel.GstTunerAPI;
import org.gstreamer.lowlevel.NativeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GstTypes {
    private static final Logger logger = Logger.getLogger(GstTypes.class.getName());
    private static final Map<Pointer, Class<? extends NativeObject>> gTypeInstanceMap = new ConcurrentHashMap<Pointer, Class<? extends NativeObject>>();

    private GstTypes() {
    }

    public static final boolean isGType(Pointer p, long type) {
        return GstTypes.getGType(p).longValue() == type;
    }

    public static final GType getGType(Pointer ptr) {
        Pointer g_class = ptr.getPointer(0L);
        return GType.valueOf(g_class.getNativeLong(0L).longValue());
    }

    public static final Class<? extends NativeObject> classFor(Pointer ptr) {
        Pointer g_class = ptr.getPointer(0L);
        Class<? extends NativeObject> cls = gTypeInstanceMap.get(g_class);
        if (cls != null) {
            return cls;
        }
        GType type = GType.valueOf(g_class.getNativeLong(0L).longValue());
        logger.finer("Type of " + ptr + " = " + (Object)((Object)type));
        while (cls == null && !type.equals((Object)GType.OBJECT) && !type.equals((Object)GType.INVALID)) {
            cls = GstTypes.getTypeMap().get((Object)type);
            if (cls != null) {
                logger.finer("Found type of " + ptr + " = " + cls);
                gTypeInstanceMap.put(g_class, cls);
                break;
            }
            type = GObjectAPI.GOBJECT_API.g_type_parent(type);
        }
        return cls;
    }

    public static final Class<? extends NativeObject> classFor(GType type) {
        return GstTypes.getTypeMap().get((Object)type);
    }

    public static final GType typeFor(Class<? extends NativeObject> cls) {
        for (Map.Entry<GType, Class<? extends NativeObject>> e : GstTypes.getTypeMap().entrySet()) {
            if (!e.getValue().equals(cls)) continue;
            return e.getKey();
        }
        return GType.INVALID;
    }

    private static final Map<GType, Class<? extends NativeObject>> getTypeMap() {
        return StaticData.typeMap;
    }

    private static class StaticData {
        private static final API gst = GstNative.load(API.class);
        private static final Map<GType, Class<? extends NativeObject>> typeMap = new HashMap<GType, Class<? extends NativeObject>>(){
            {
                this.put(GstColorBalanceAPI.GSTCOLORBALANCE_API.gst_color_balance_channel_get_type(), ColorBalanceChannel.class);
                this.put(GstMixerAPI.GSTMIXER_API.gst_mixer_track_get_type(), MixerTrack.class);
                this.put(GstTunerAPI.GSTTUNER_API.gst_tuner_channel_get_type(), TunerChannel.class);
                this.put(GstTunerAPI.GSTTUNER_API.gst_tuner_norm_get_type(), TunerNorm.class);
                this.put(gst.gst_element_get_type(), Element.class);
                this.put(gst.gst_clock_get_type(), Clock.class);
                this.put(gst.gst_pipeline_get_type(), Pipeline.class);
                this.put(gst.gst_bus_get_type(), Bus.class);
                this.put(gst.gst_pad_get_type(), Pad.class);
                this.put(gst.gst_pad_template_get_type(), PadTemplate.class);
                this.put(gst.gst_ghost_pad_get_type(), GhostPad.class);
                this.put(gst.gst_plugin_get_type(), Plugin.class);
                this.put(gst.gst_plugin_feature_get_type(), PluginFeature.class);
                this.put(gst.gst_registry_get_type(), Registry.class);
                this.put(gst.gst_buffer_get_type(), Buffer.class);
                this.put(gst.gst_event_get_type(), Event.class);
                this.put(gst.gst_message_get_type(), Message.class);
                this.put(gst.gst_query_get_type(), Query.class);
                this.put(BaseAPI.BASE_API.gst_base_sink_get_type(), BaseSink.class);
                this.put(BaseAPI.BASE_API.gst_base_src_get_type(), BaseSrc.class);
                this.put(gst.gst_type_find_get_type(), TypeFind.class);
                this.put(gst.gst_element_factory_get_type(), ElementFactory.class);
                this.put(gst.gst_bin_get_type(), Bin.class);
            }
        };

        private StaticData() {
        }

        private static interface API
        extends Library {
            public GType gst_base_src_get_type();

            public GType gst_base_sink_get_type();

            public GType gst_bin_get_type();

            public GType gst_buffer_get_type();

            public GType gst_bus_get_type();

            public GType gst_caps_get_type();

            public GType gst_child_proxy_get_type();

            public GType gst_clock_get_type();

            public GType gst_element_get_type();

            public GType gst_element_factory_get_type();

            public GType gst_event_get_type();

            public GType gst_g_error_get_type();

            public GType gst_ghost_pad_get_type();

            public GType gst_index_get_type();

            public GType gst_index_entry_get_type();

            public GType gst_index_factory_get_type();

            public GType gst_message_get_type();

            public GType gst_mini_object_get_type();

            public GType gst_object_get_type();

            public GType gst_pad_get_type();

            public GType gst_pad_template_get_type();

            public GType gst_pipeline_get_type();

            public GType gst_plugin_get_type();

            public GType gst_plugin_feature_get_type();

            public GType gst_query_get_type();

            public GType gst_registry_get_type();

            public GType gst_segment_get_type();

            public GType gst_static_pad_template_get_type();

            public GType gst_static_caps_get_type();

            public GType gst_system_clock_get_type();

            public GType gst_structure_get_type();

            public GType gst_tag_get_type(String var1);

            public GType gst_tag_list_get_type();

            public GType gst_tag_setter_get_type();

            public GType gst_task_get_type();

            public GType gst_type_find_get_type();

            public GType gst_type_find_factory_get_type();

            public GType gst_uri_handler_get_type();
        }
    }
}

