/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.swt.overlay;

import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import java.lang.reflect.Field;
import org.eclipse.swt.widgets.Control;
import org.gstreamer.Element;
import org.gstreamer.GstException;
import org.gstreamer.interfaces.XOverlay;
import org.gstreamer.lowlevel.GstXOverlayAPI;

public class SWTOverlay
extends XOverlay {
    public static SWTOverlay wrap(Element element) {
        return new SWTOverlay(element);
    }

    private SWTOverlay(Element element) {
        super(element);
    }

    public static long getLinuxHandle(Control control) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Class<?> controlClass = control.getClass();
        Field embedHandleField = controlClass.getField("embeddedHandle");
        Class<?> t = embedHandleField.getType();
        if (t.equals(Long.TYPE)) {
            return embedHandleField.getLong(control);
        }
        if (t.equals(Integer.TYPE)) {
            return embedHandleField.getInt(control);
        }
        return 0L;
    }

    public static long handle(Control control) {
        if (control == null || (control.getStyle() | 0x1000000) == 0) {
            return 0L;
        }
        if (Platform.isWindows()) {
            return control.handle;
        }
        if (Platform.isLinux()) {
            try {
                return SWTOverlay.getLinuxHandle(control);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public void setWindowID(Control control) {
        if (control == null || (control.getStyle() | 0x1000000) == 0) {
            throw new GstException("Cannot set window ID, in XOverlay interface, control is null or not SWT.EMBEDDED");
        }
        if (Platform.isWindows()) {
            GstXOverlayAPI.GSTXOVERLAY_API.gst_x_overlay_set_xwindow_id((XOverlay)this, new NativeLong((long)control.handle));
        } else if (Platform.isLinux()) {
            try {
                GstXOverlayAPI.GSTXOVERLAY_API.gst_x_overlay_set_xwindow_id((XOverlay)this, new NativeLong(SWTOverlay.getLinuxHandle(control)));
            }
            catch (Exception e) {
                throw new GstException("Cannot set window ID, in XOverlay interface, can't get embeddedHandle. " + e.getLocalizedMessage());
            }
        } else {
            throw new GstException("Cannot set window ID, in XOverlay interface: not supported sink element on platform");
        }
    }
}

