/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.swt.overlay;

import com.sun.jna.Platform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.swt.overlay.SWTOverlay;

public class VideoComponent
extends Canvas {
    private double aspectY = 0.0;
    private double aspectX = 0.0;
    private final Element videosink = ElementFactory.make(Platform.isWindows() ? "directdrawsink" : "xvimagesink", "OverlayVideoComponent");

    public VideoComponent(Composite parent, int style) {
        super(parent, style | 0x1000000);
        SWTOverlay.wrap(this.videosink).setWindowID((Control)this);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (VideoComponent.this.aspectX == 0.0 || VideoComponent.this.aspectY == 0.0) {
                    return;
                }
                int newX = VideoComponent.this.getSize().x;
                int newY = VideoComponent.this.getSize().y;
                double coX = (double)VideoComponent.this.getSize().x / VideoComponent.this.aspectY;
                double coY = (double)VideoComponent.this.getSize().y / VideoComponent.this.aspectX;
                if (coY <= coX) {
                    newX = (int)(coY * VideoComponent.this.aspectY);
                } else {
                    newY = (int)(coX * VideoComponent.this.aspectX);
                }
                VideoComponent.this.setSize(newX, newY);
                VideoComponent.this.setLocation(VideoComponent.this.getSize().x / 2 - VideoComponent.this.getSize().x / 2, VideoComponent.this.getSize().y / 2 - VideoComponent.this.getSize().y / 2);
                VideoComponent.this.layout(true);
            }
        });
    }

    public void setAspectRatio(double x, double y) {
        this.aspectX = x;
        this.aspectY = y;
    }

    public Element getElement() {
        return this.videosink;
    }

    public void setKeepAspect(boolean keepAspect) {
        this.videosink.set("force-aspect-ratio", true);
    }
}

