/*
 * Decompiled with CFR 0.152.
 */
package org.gwizard.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.configuration.ConfigurationException;
import io.dropwizard.configuration.ConfigurationFactory;
import io.dropwizard.configuration.YamlConfigurationFactory;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Validator;
import org.gwizard.config.ConfigClass;
import org.gwizard.config.ConfigFile;
import org.gwizard.config.PropertyPrefix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProvider<T>
implements Provider<T> {
    private static final Logger log = LoggerFactory.getLogger(ConfigProvider.class);
    private final ConfigurationFactory<?> configurationFactory;
    private final File configFile;

    @Inject
    public ConfigProvider(Validator validator, ObjectMapper objectMapper, @ConfigClass Class<?> configClass, @PropertyPrefix String propertyPrefix, @ConfigFile File configFile) {
        this.configurationFactory = new YamlConfigurationFactory(configClass, validator, objectMapper, propertyPrefix);
        this.configFile = configFile;
    }

    public T get() {
        if (!this.configFile.exists()) {
            throw new IllegalStateException("No such config file " + this.configFile);
        }
        try {
            return (T)this.configurationFactory.build(this.configFile);
        }
        catch (ConfigurationException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigProvider(ConfigurationFactory<?> configurationFactory, File configFile) {
        this.configurationFactory = configurationFactory;
        this.configFile = configFile;
    }
}

