/*
 * Decompiled with CFR 0.152.
 */
package org.gwizard.config;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import jakarta.inject.Singleton;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.beans.ConstructorProperties;
import java.io.File;
import lombok.Generated;
import org.gwizard.config.ConfigClass;
import org.gwizard.config.ConfigFile;
import org.gwizard.config.ConfigProvider;
import org.gwizard.config.PropertyPrefix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigModule
extends AbstractModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigModule.class);
    private final File configFile;
    private final Class<?> configClass;
    private final String propertyPrefix;

    public ConfigModule(File configFile, Class<?> configClass) {
        this(configFile, configClass, "gw");
    }

    protected void configure() {
        this.bind(this.configClass).toProvider((TypeLiteral)new TypeLiteral<ConfigProvider<Object>>(){}).in(Singleton.class);
    }

    @Provides
    @PropertyPrefix
    public String propertyPrefix() {
        return this.propertyPrefix;
    }

    @Provides
    @ConfigClass
    public Class<?> configClass() {
        return this.configClass;
    }

    @Provides
    @ConfigFile
    public File configFile() {
        return this.configFile;
    }

    @Provides
    @Singleton
    public Validator validator() {
        return Validation.buildDefaultValidatorFactory().getValidator();
    }

    @ConstructorProperties(value={"configFile", "configClass", "propertyPrefix"})
    @Generated
    public ConfigModule(File configFile, Class<?> configClass, String propertyPrefix) {
        this.configFile = configFile;
        this.configClass = configClass;
        this.propertyPrefix = propertyPrefix;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigModule)) {
            return false;
        }
        ConfigModule other = (ConfigModule)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigModule;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

