/*
 * Decompiled with CFR 0.152.
 */
package org.gwizard.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.Generated;

public class ImportingConfigurationSourceProvider
implements ConfigurationSourceProvider {
    static final ObjectMapper MAPPER = new ObjectMapper(new YAMLFactory().configure(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION, true));

    public InputStream open(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException("File '" + file + "' not found");
        }
        ObjectNode root = (ObjectNode)MAPPER.readTree(file);
        this.processImports(root, file);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        MAPPER.writeValue((OutputStream)buffer, (Object)root);
        return new ByteArrayInputStream(buffer.toByteArray());
    }

    private void processImports(ObjectNode root, File rootFile) throws IOException {
        JsonNode imports = root.path("gwizard").path("import");
        if (imports.isEmpty()) {
            return;
        }
        root.remove("gwizard");
        for (JsonNode anImport : imports) {
            ObjectNode imported = this.importFile(anImport.textValue(), rootFile);
            this.merge(root, imported);
        }
    }

    private ObjectNode importFile(String path, File rootFile) throws IOException {
        File file = this.resolveFile(path, rootFile);
        if (!file.exists()) {
            throw new FileNotFoundException("Import file '" + file + "' not found");
        }
        return (ObjectNode)MAPPER.readTree(file);
    }

    private File resolveFile(String path, File rootFile) {
        if (path.startsWith(File.separator)) {
            return new File(path);
        }
        return new File(rootFile.getParent(), path);
    }

    private void merge(ObjectNode root, ObjectNode imported) {
        imported.fieldNames().forEachRemaining(fieldName -> {
            JsonNode valueToBeUpdated = root.get(fieldName);
            JsonNode valueToUpdate = imported.get(fieldName);
            if (valueToBeUpdated != null && valueToBeUpdated.isObject() && valueToUpdate != null && valueToUpdate.isObject()) {
                this.merge((ObjectNode)valueToBeUpdated, (ObjectNode)valueToUpdate);
            } else {
                root.set(fieldName, valueToUpdate);
            }
        });
    }

    @Generated
    public ImportingConfigurationSourceProvider() {
    }
}

