/*
 * Decompiled with CFR 0.152.
 */
package org.gwizard.swagger;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import io.swagger.config.ScannerFactory;
import io.swagger.jaxrs.config.BeanConfig;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.gwizard.swagger.SwaggerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SwaggerServletContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(SwaggerServletContextListener.class);
    private final SwaggerConfig swaggerConfig;

    @Inject
    SwaggerServletContextListener(SwaggerConfig swaggerConfig) {
        this.swaggerConfig = swaggerConfig;
    }

    public void contextInitialized(ServletContextEvent event) {
        log.debug("Handling servlet context event. Configuring Swagger...");
        BeanConfig beanConfig = SwaggerServletContextListener.createBeanConfig(this.swaggerConfig);
        event.getServletContext().setAttribute("reader", (Object)beanConfig);
        event.getServletContext().setAttribute("swagger", (Object)beanConfig.getSwagger());
        event.getServletContext().setAttribute("scanner", (Object)ScannerFactory.getScanner());
    }

    static BeanConfig createBeanConfig(SwaggerConfig swaggerConfig) {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setHost(swaggerConfig.getHost());
        beanConfig.setBasePath(swaggerConfig.getBasePath());
        beanConfig.setPrettyPrint(swaggerConfig.isPrettyPrint());
        List<String> resourcePackages = swaggerConfig.getResourcePackages();
        beanConfig.setResourcePackage(Joiner.on((String)",").join(resourcePackages));
        if (resourcePackages.isEmpty()) {
            log.warn("No resource packages configured");
        } else {
            log.debug("Added resource packages {} to swagger bean config", resourcePackages);
        }
        beanConfig.setScan(true);
        return beanConfig;
    }

    public void contextDestroyed(ServletContextEvent event) {
    }
}

