/*
 * Decompiled with CFR 0.152.
 */
package org.gwizard.test;

import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.google.inject.BindingAnnotation;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gwizard.test.GuicyTest;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class GuiceExtension
implements BeforeEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{GuiceExtension.class});

    public void beforeEach(ExtensionContext context) throws Exception {
        Object testInstanceRaw = context.getTestInstance().get();
        if (!(testInstanceRaw instanceof GuicyTest)) {
            throw new IllegalStateException("Class " + testInstanceRaw.getClass().getName() + " must implement " + GuicyTest.class.getSimpleName());
        }
        GuicyTest testInstance = (GuicyTest)testInstanceRaw;
        Module module = testInstance.module();
        Injector injector = Guice.createInjector((Module[])new Module[]{module});
        context.getStore(NAMESPACE).put(Injector.class, (Object)injector);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        if (GuiceExtension.getBindingAnnotations(parameter).size() > 1) {
            return false;
        }
        Injector injector = GuiceExtension.getInjector(extensionContext);
        if (injector == null) {
            return false;
        }
        Key<?> key = GuiceExtension.getKey(parameter);
        return injector.getExistingBinding(key) != null;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        Key<?> key = GuiceExtension.getKey(parameter);
        Injector injector = GuiceExtension.getInjector(extensionContext);
        return injector.getInstance(key);
    }

    public static Injector getInjector(ExtensionContext context) {
        return (Injector)context.getStore(NAMESPACE).get(Injector.class, Injector.class);
    }

    private static List<Annotation> getBindingAnnotations(AnnotatedElement element) {
        return Arrays.stream(element.getAnnotations()).filter(GuiceExtension::isBindingAnnotation).collect(Collectors.toList());
    }

    private static boolean isBindingAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        return annotationType.isAnnotationPresent(Qualifier.class) || annotationType.isAnnotationPresent(BindingAnnotation.class);
    }

    private static Key<?> getKey(Parameter parameter) {
        TypeToken classType = TypeToken.of(parameter.getDeclaringExecutable().getDeclaringClass());
        Type resolvedType = classType.resolveType(parameter.getParameterizedType()).getType();
        Optional<Key> key = GuiceExtension.getOnlyBindingAnnotation(parameter).map(annotation -> Key.get((Type)resolvedType, (Annotation)annotation));
        return key.orElse(Key.get((Type)resolvedType));
    }

    private static Optional<? extends Annotation> getOnlyBindingAnnotation(AnnotatedElement element) {
        return Optional.ofNullable((Annotation)Iterables.getOnlyElement(GuiceExtension.getBindingAnnotations(element), null));
    }
}

