/*
 * Decompiled with CFR 0.152.
 */
package org.gwizard.test;

import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.gwizard.test.RequestFilter;

@Singleton
public class Requestor {
    private final List<RequestFilter> filters = new ArrayList<RequestFilter>();

    public void addFilter(RequestFilter filter) {
        this.filters.add(filter);
    }

    public <T> T req(Callable<T> callable) throws Exception {
        return this.wrap(callable, this.filters.size() - 1).call();
    }

    public final void req(Runnable runnable) throws Exception {
        this.req(() -> {
            runnable.run();
            return null;
        });
    }

    private <T> Callable<T> wrap(Callable<T> callable, int index) {
        if (index < 0) {
            return callable;
        }
        Callable<T> filtered = this.filters.get(index).filter(callable);
        return this.wrap(filtered, index - 1);
    }
}

