/*
 * Decompiled with CFR 0.152.
 */
package org.gwizard.web;

import com.google.inject.Binding;
import com.google.inject.Injector;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;

public class Scanner<T> {
    private final Injector injector;
    private final Class<T> scanFor;

    public void accept(Visitor<T> visitor) {
        this.accept(this.injector, visitor);
    }

    private void accept(Injector inj, Visitor visitor) {
        if (inj == null) {
            return;
        }
        this.accept(inj.getParent(), visitor);
        for (Binding binding : inj.getBindings().values()) {
            Type type = binding.getKey().getTypeLiteral().getType();
            if (!(type instanceof Class) || !this.scanFor.isAssignableFrom((Class)type)) continue;
            visitor.visit(binding.getProvider().get());
        }
    }

    @ConstructorProperties(value={"injector", "scanFor"})
    public Scanner(Injector injector, Class<T> scanFor) {
        this.injector = injector;
        this.scanFor = scanFor;
    }

    public static interface Visitor<V> {
        public void visit(V var1);
    }
}

