/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.api;

import java.io.Closeable;
import java.io.IOException;
import org.hansken.plugin.extraction.util.ArgChecks;

public interface RandomAccessData
extends Closeable {
    public long size();

    public long position();

    default public long remaining() {
        return this.size() - this.position();
    }

    public void seek(long var1) throws IOException;

    default public int read(byte[] buffer) throws IOException {
        return this.read(buffer, RandomAccessData.min(buffer.length, this.remaining()));
    }

    default public int read(byte[] buffer, int count) throws IOException {
        return this.read(buffer, 0, RandomAccessData.min(count, this.remaining()));
    }

    public int read(byte[] var1, int var2, int var3) throws IOException;

    default public byte[] readNBytes(int count) throws IOException {
        ArgChecks.argNotNegative("count", count);
        byte[] buffer = new byte[RandomAccessData.min(count, this.remaining())];
        this.read(buffer);
        return buffer;
    }

    private static int min(long a, long b) {
        return Math.toIntExact(Math.min(a, b));
    }
}

