package org.hansken.plugin.extraction.api;

/**
 * The data context contains information about a data stream of a trace that is currently being
 * processed by an {@link ExtractionPlugin} or {@link DeferredExtractionPlugin}.
 *
 * @see ExtractionPlugin#process(Trace, DataContext)
 */
public interface DataContext {

    /**
     * The type of data (see {@link #data()}) that is being processed. The type is never empty or {@code null}.
     * This is the type of data the given data sequence represents, for example "{@code raw}" for raw
     * bytes or "{@code plain}" for plaintext.
     * <p>
     * The data type will be one of those defined on the trace model associated with the trace being processed.
     *
     * @return the name of the data type
     */
    String dataType();

    /**
     * A {@link RandomAccessData data sequence} belonging to the trace currently being extracted. If necessary,
     * the type of the underlying data can be requested using {@link DataContext#dataType()}.
     *
     * @return the data sequence
     */
    RandomAccessData data();
}
