package org.hansken.plugin.extraction.api;

import java.util.concurrent.ExecutionException;

/**
 * Allows searching for traces within the scope of the process function.
 */
public interface TraceSearcher {
    /**
     * Searches in Hansken for Traces matching provided query.
     *
     * @param query Search query to match traces. This is a HQL query.
     * @param count Maximum number of traces to return.
     * @return SearchResult containing traces matching the provided query.
     * @throws InterruptedException if a thread searching for traces is interrupted.
     * @throws ExecutionException if searching for traces is throws an exception.
     */
    SearchResult search(String query, int count) throws InterruptedException, ExecutionException;
}
