package org.hansken.plugin.extraction.api;

/**
 * This the base class for types of Extraction Plugins, and cannot be used solely as a superclass for a plugin.
 * Implement one of its subclasses that have a 'process' method.
 * Extraction plugins can be used by Hansken to process data during the extraction process.
 */
public interface BaseExtractionPlugin {

    /**
     * Get the {@link PluginInfo information} of this plugin, such as the author or a description, and the
     * types of {@link Trace traces} and {@link RandomAccessData data} it matches on.
     *
     * @return the metadata of the plugin
     */
    PluginInfo pluginInfo();

}
