package org.hansken.plugin.extraction.api.transformations;

/**
 * A DataRange describes a range of bytes with an offset and length.
 *
 * @author Netherlands Forensic Institute
 */
public class DataRange {

    private long _offset;
    private long _length;

    /**
     * Creates a {@link DataRange} which describes a range of bytes.
     * @param offset the starting point of the data
     * @param length the size of the data
     */
    public DataRange(final long offset, final long length) {
        this._offset = offset;
        this._length = length;
    }

    public long getOffset() {
        return _offset;
    }

    public long getLength() {
        return _length;
    }

    public void setOffset(final long offset) {
        _offset = offset;
    }

    public void setLength(final long length) {
        _length = length;
    }

}
