/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.api.transformations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hansken.plugin.extraction.api.transformations.DataRange;
import org.hansken.plugin.extraction.api.transformations.DataTransformation;

public class RangedDataTransformation
implements DataTransformation {
    private List<DataRange> _ranges;

    public RangedDataTransformation(List<DataRange> ranges) {
        this._ranges = ranges;
    }

    public RangedDataTransformation(DataRange ... ranges) {
        this._ranges = Arrays.asList(ranges);
    }

    public List<DataRange> getRanges() {
        return this._ranges;
    }

    public void setRanges(List<DataRange> ranges) {
        this._ranges = ranges;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<DataRange> _ranges = new ArrayList<DataRange>();

        public Builder add(List<DataRange> dataRange) {
            this._ranges.addAll(dataRange);
            return this;
        }

        public Builder add(DataRange ... dataRange) {
            this.add(List.of(dataRange));
            return this;
        }

        public Builder addRange(long offset, long length) {
            this._ranges.add(new DataRange(offset, length));
            return this;
        }

        public RangedDataTransformation build() {
            return new RangedDataTransformation(this._ranges);
        }
    }
}

