/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.api;

import org.hansken.plugin.extraction.util.ArgChecks;

public final class PluginResources {
    private final Float _maxCpu;
    private final Integer _maxMemory;
    private final Integer _maxWorkers;

    private PluginResources(Float maxCpu, Integer maxMemory, Integer maxWorkers) {
        this._maxCpu = maxCpu;
        this._maxMemory = maxMemory;
        this._maxWorkers = maxWorkers;
    }

    public Float maximumCpu() {
        return this._maxCpu;
    }

    public Integer maximumMemory() {
        return this._maxMemory;
    }

    public Integer maximumWorkers() {
        return this._maxWorkers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Float _maxCpu;
        private Integer _maxMemory;
        private Integer _maxWorkers;

        private Builder() {
        }

        public Builder maximumCpu(float quantity) {
            this._maxCpu = Float.valueOf(ArgChecks.argNotNegative("quantity", quantity));
            return this;
        }

        public Builder maximumMemory(int quantity) {
            this._maxMemory = ArgChecks.argNotNegative("quantity", quantity);
            return this;
        }

        public Builder maximumWorkers(int quantity) {
            this._maxWorkers = ArgChecks.argNotNegative("quantity", quantity);
            return this;
        }

        public PluginResources build() {
            return new PluginResources(this._maxCpu, this._maxMemory, this._maxWorkers);
        }
    }
}

