package org.hansken.plugin.extraction.api;

import java.io.IOException;
import java.io.OutputStream;

/**
 * Writes data to an {@link OutputStream}. Used to enable lambda callbacks in for example
 * {@link Trace#setData(String, DataWriter)}.
 */
public interface DataWriter {

    /**
     * Write data to given {@link OutputStream}.
     * <p>
     * <strong>Note:</strong> the received output stream should <i>not</i> be closed by the user. It should
     * also only be used within the scope of the function, other usage may be guarded against or otherwise
     * result in undefined behaviour.
     *
     * @param stream the stream to write data to
     * @throws IOException when an I/O error occurs
     */
    void writeTo(OutputStream stream) throws IOException;
}
