package org.hansken.plugin.extraction.api;

import java.io.IOException;

import org.hansken.plugin.extraction.util.ThrowingConsumer;

/**
 * Extraction plugins can be used by Hansken to process {@link Trace traces} during the extraction process.
 * A processed trace can be enriched with new information and new child traces can also be created.
 * <p>
 * When a plugin matches on the trace which is currently processed by Hansken
 * (for example, because it has certain properties or a certain type of data sequence), the plugin will receive the
 * matched trace and data in order to process it (see {@link #process(Trace, DataContext)}).
 */
public interface ExtractionPlugin extends BaseExtractionPlugin {

    /**
     * Start processing a {@link Trace trace} with a given {@link DataContext data context}.
     *
     * When processing a given trace, new properties may be set on it. New children can be added using
     * {@link Trace#newChild(String, ThrowingConsumer)}.
     * <p>
     * A trace can have multiple data sequences of different types. Because of this, a certain trace might
     * be processed multiple times (depending on if this plugin triggers on the different data types).
     * <p>
     * <strong>Note:</strong> the given trace should only be modified within the scope of this method.
     * Any modifications afterward may be guarded against or result in undefined behavior.
     *
     * @param trace the trace to process
     * @param dataContext data context of the traces data stream that is being processed
     * @throws IOException when an I/O error occurs
     */
    void process(Trace trace, DataContext dataContext) throws IOException;
}
