package org.hansken.plugin.extraction.api;

import java.util.stream.Stream;

/**
 * A {@link SearchResult} represents the result of a {@link TraceSearcher#search(String, int)}.
 * A {@link SearchResult} contains found traces and the
 * total number of traces that respond to a given query. This may not be the same number, because the number
 * of traces returned is limited by the count provided in a {@link TraceSearcher#search(String, int)}.
 */
public interface SearchResult {
    /**
     * Returns all found traces.
     *
     * @return found traces.
     */
    Stream<SearchTrace> getTraces();

    /**
     * Returns the total number of traces matching the query.
     *
     * @return total number of matching traces
     */
    long getTotalHits();
}
