package org.hansken.plugin.extraction.api;

import java.util.List;

/**
 * A trace contains information about processed data. A trace should conform to the trace model defined by Hansken.
 * Unlike a {@link Trace}, the {@code SearchTrace} contains information about the searched trace. It is able to
 * directly retrieve all the data contexts belonging to a searched trace. When data type is known a
 * {@link RandomAccessData} can be retrieved directly.
 */
public interface SearchTrace extends ImmutableTrace {

    /**
     * Returns a {@link RandomAccessData} for a specific trace data type.
     * @param type the data type of the data stream to be retrieved
     * @return the data stream
     */
    RandomAccessData getData(String type);

    /**
     * Returns all available data types for this search trace.
     * @return available data types
     */
    List<String> getDataTypes();
}
