package org.hansken.plugin.extraction.util;

/**
 * Represents an operation that accepts a single input argument and returns no result.
 * Replaces the normal Java Consumer and enables throwing an {@link Exception} from the callback. Used to enable
 * lambda callbacks in for example {@link org.hansken.plugin.extraction.api.Trace#newChild(String, ThrowingConsumer)}.
 * @param <T> the type of the input to the operation
 * @param <E> the type of the {@link Throwable} which can be thrown by the operation
 */
@FunctionalInterface
public interface ThrowingConsumer<T, E extends Throwable> {

    /**
     * Performs this operation on the given argument.
     * @param t the input argument
     * @throws E when an exception occurs
     */
    void accept(T t) throws E;
}
