package org.hansken.plugin.extraction.api;

import java.util.stream.Stream;

/**
 * A {@link BatchSearchResult} is a {@link SearchResult} implementation that stores all found traces using a single setTraces call.
 */
public class BatchSearchResult implements SearchResult {
    private final long _totalResults;
    private SearchTrace[] _traces;

    public BatchSearchResult(final long totalResults) {
        _totalResults = totalResults;
    }

    @Override
    public Stream<SearchTrace> getTraces() {
        return Stream.of(_traces);
    }

    /**
     * Sets all traces that can be returned by calling getTraces.
     *
     * @param traces an array of ImmutableTraces.
     */
    public void setTraces(final SearchTrace[] traces) {
        _traces = traces;
    }

    @Override
    public long getTotalHits() {
        return _totalResults;
    }
}
