package org.hansken.plugin.extraction.api;

/**
 * Indicates what stage of maturity a certain {@link ExtractionPlugin extraction plugin} is in.
 */
public enum MaturityLevel {

    /** The {@link ExtractionPlugin plugin} is in a proof of concept phase, not yet ready for test or production. */
    PROOF_OF_CONCEPT,
    /** The {@link ExtractionPlugin plugin} can be used in a test environment and is expected to be fully functional. */
    READY_FOR_TEST,
    /** The {@link ExtractionPlugin plugin} is ready to be used in a production environment. */
    PRODUCTION_READY
}