/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.api;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hansken.plugin.extraction.api.LatLong;
import org.hansken.plugin.extraction.api.Vector;

public class TransformerArgument {
    private final Object _argument;
    private final List<Class<?>> _allowedTypes = List.of(Boolean.class, byte[].class, Long.class, Double.class, String.class, Vector.class, LatLong.class, ZonedDateTime.class, List.class, Map.class);

    public TransformerArgument(Object argument) {
        this._argument = this.validate(argument);
    }

    private Object validate(Object argument) {
        boolean validType = this._allowedTypes.stream().anyMatch(type -> type.isInstance(argument));
        if (!validType) {
            throw new IllegalArgumentException("Invalid object type used to construct TransformerArgument. " + String.format(Locale.ROOT, "Passed value is %s but may only be %s", argument.getClass().getName(), this._allowedTypes));
        }
        return argument;
    }

    public Object getArgument() {
        return this._argument;
    }
}

