package org.hansken.plugin.extraction.api;

import java.util.Set;

/**
 * A trace contains information about processed data. A trace should conform to the trace model defined by Hansken.
 * Unlike a {@link Trace}, an {@link ImmutableTrace} instance lacks methods to modify or update its properties and data
 * streams after the instance is created.
 */
public interface ImmutableTrace {

    /**
     * Get the trace id of this trace.
     * Note: This value is equal to the id of a Hansken Trace.
     *
     * @return the id of this trace
     */
    String traceId();

    /**
     * Get all the types of this trace.
     *
     * @return all types of this trace
     */
    Set<String> types();

    /**
     * Return the names of all the properties contained in this trace.
     *
     * @return the properties of this trace
     */
    Set<String> properties();

    /**
     * Get the value of the property with given {@code name} on this trace.
     * <p>
     * <strong>Note: </strong> the method is declared with a type parameter to allow for
     * automatic casting. It is an unchecked cast, so implementers have to make sure that
     * the type of the value returned is of type {@code T}.
     *
     * @param name the name of the value to get
     * @param <T> the type of the value
     * @return the value of the property
     */
    <T> T get(String name);
}
