/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.hansken.plugin.extraction.api.DataWriter;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.api.SearchTrace;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.transformations.DataTransformation;
import org.hansken.plugin.extraction.core.data.test.TestData;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;

public class TestTrace
implements ClientTrace,
SearchTrace {
    private final String _name;
    private String _traceId = "0";
    private final Set<String> _types = new HashSet<String>();
    private final Map<String, Object> _properties = new HashMap<String, Object>();
    private final List<Trace.Tracelet> _tracelets = new ArrayList<Trace.Tracelet>();
    private final List<TestTrace> _children = new ArrayList<TestTrace>();
    private final Map<String, byte[]> _dataStreams = new HashMap<String, byte[]>();
    private final Map<String, List<DataTransformation>> _transformations = new HashMap<String, List<DataTransformation>>();
    private Consumer<TestTrace> _onSave;

    public TestTrace(String name) {
        this._name = name;
        this.set("name", name);
    }

    public static TestTrace emptyTrace() {
        return new TestTrace("root");
    }

    public TestTrace withOnSaveCallback(Consumer<TestTrace> onSave) {
        this._onSave = onSave;
        return this;
    }

    public List<TestTrace> children() {
        return this._children;
    }

    public Map<String, byte[]> dataStreams() {
        return this._dataStreams;
    }

    public String traceId() {
        return this._traceId;
    }

    public TestTrace setTraceId(String traceId) {
        this._traceId = traceId;
        return this;
    }

    public Set<String> types() {
        return this._types;
    }

    public Trace addType(String type) {
        this._types.add(type);
        return this;
    }

    public Set<String> properties() {
        return this._properties.keySet();
    }

    public List<Trace.Tracelet> traceletProperties() {
        return this._tracelets;
    }

    public <T> T get(String name) {
        return (T)this._properties.get(name);
    }

    public Trace set(String name, Object value) {
        this._properties.put(name, value);
        return this;
    }

    public Trace addTracelet(Trace.Tracelet tracelet) {
        this._tracelets.add(tracelet);
        return this;
    }

    public Trace setData(String dataType, DataWriter writer) throws IOException {
        if (this._dataStreams.containsKey(dataType)) {
            throw new IllegalArgumentException("trace already contains data stream of type: " + dataType);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        writer.writeTo((OutputStream)output);
        this._dataStreams.put(dataType, output.toByteArray());
        this.set("data." + dataType + ".size", output.size());
        return this;
    }

    public Trace setData(String dataType, List<DataTransformation> transformations) {
        this._transformations.put(dataType, transformations);
        return this;
    }

    public Map<String, List<DataTransformation>> getTransformations() {
        return this._transformations;
    }

    public void save() {
        if (this._onSave != null) {
            this._onSave.accept(this);
        }
    }

    public ClientTrace newChild(String name) {
        TestTrace child = new TestTrace(name).withOnSaveCallback(this._onSave);
        this._children.add(child);
        return child;
    }

    public String name() {
        return this._name;
    }

    public String toString() {
        return this._properties.toString();
    }

    public RandomAccessData getData(String type) {
        return TestData.fromBytes((byte[])this._dataStreams.get(type));
    }

    public List<String> getDataTypes() {
        return new ArrayList<String>(this._dataStreams.keySet());
    }
}

