/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class RetryPolicy {
    private int _maxAttempts;
    private Duration _initialBackoff;
    private Duration _maxBackOff;
    private double _backOffMultiplier;

    public static RetryPolicy withDefaultSettings() {
        return new RetryPolicy().maxAttempts(10).initialBackoffMs(Duration.ofMillis(250L)).maxBackOff(Duration.ofSeconds(10L)).backOffMultiplier(2.0);
    }

    int maxAttempts() {
        return this._maxAttempts;
    }

    public RetryPolicy maxAttempts(int maxAttempts) {
        this._maxAttempts = maxAttempts;
        return this;
    }

    public RetryPolicy initialBackoffMs(Duration initialBackoff) {
        this._initialBackoff = initialBackoff;
        return this;
    }

    public RetryPolicy maxBackOff(Duration maxBackOff) {
        this._maxBackOff = maxBackOff;
        return this;
    }

    public RetryPolicy backOffMultiplier(double backOffMultiplier) {
        this._backOffMultiplier = backOffMultiplier;
        return this;
    }

    Map<String, Object> toMethodConfigMap() {
        return Map.of("methodConfig", List.of(Map.of("name", List.of(Map.of("service", "org.hansken.extraction.plugin.grpc.ExtractionPluginService", "method", "pluginInfo"), Map.of("service", "org.hansken.extraction.plugin.grpc.ExtractionPluginService", "method", "process")), "retryPolicy", Map.of("maxAttempts", Double.valueOf(this._maxAttempts), "initialBackoff", (double)this._initialBackoff.toMillis() / 1000.0 + "s", "maxBackoff", (double)this._maxBackOff.toMillis() / 1000.0 + "s", "backoffMultiplier", this._backOffMultiplier, "retryableStatusCodes", Collections.singletonList("UNAVAILABLE")))));
    }
}

