/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.api.SearchTrace;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginDataReader;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;
import org.hansken.plugin.extraction.runtime.grpc.test.TestTrace;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ExtractionPluginDataReaderTest {
    @Test
    void readDefaultExtractionTrace() throws IOException {
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        RandomAccessData data = (RandomAccessData)Mockito.mock(RandomAccessData.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)data);
        ExtractionPluginDataReader reader = new ExtractionPluginDataReader(context);
        reader.read("0", "raw", 0L, 10);
        ((RandomAccessData)Mockito.verify((Object)data)).seek(0L);
        ((RandomAccessData)Mockito.verify((Object)data)).readNBytes(10);
    }

    @Test
    void readUnavailableTrace() {
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginDataReader reader = new ExtractionPluginDataReader(context);
        Throwable error = Assertions.assertThrows(NoSuchElementException.class, () -> reader.read("0-0", "raw", 0L, 10));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"No data available for trace with uid: 0-0"));
    }

    @Test
    void readUnavailableDataType() throws IOException {
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        TestTrace trace1 = new TestTrace("result1");
        trace1.set("uid", "0-0").setData("html", writer -> writer.write(97));
        ExtractionPluginDataReader reader = new ExtractionPluginDataReader(context);
        reader.markDataAvailable((SearchTrace)trace1);
        Throwable error = Assertions.assertThrows(NoSuchElementException.class, () -> reader.read("0-0", "raw", 0L, 10));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"No data available for data type"));
    }

    @Test
    void readAvailableTrace() throws IOException {
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        RandomAccessData data = (RandomAccessData)Mockito.mock(RandomAccessData.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        Mockito.when((Object)context.data("0-0", "html")).thenReturn((Object)data);
        TestTrace trace1 = new TestTrace("result1");
        trace1.set("uid", "0-0").setData("html", writer -> writer.write(97));
        ExtractionPluginDataReader reader = new ExtractionPluginDataReader(context);
        reader.markDataAvailable((SearchTrace)trace1);
        reader.read("0-0", "html", 0L, 10);
        ((RandomAccessData)Mockito.verify((Object)data)).seek(0L);
        ((RandomAccessData)Mockito.verify((Object)data)).readNBytes(10);
    }
}

