/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.hansken.ep.shade.com.google.protobuf.Any;
import org.hansken.ep.shade.com.google.protobuf.Empty;
import org.hansken.ep.shade.io.grpc.ConnectivityState;
import org.hansken.ep.shade.io.grpc.ManagedChannel;
import org.hansken.ep.shade.io.grpc.ManagedChannelBuilder;
import org.hansken.ep.shade.io.grpc.Metadata;
import org.hansken.ep.shade.io.grpc.StatusRuntimeException;
import org.hansken.ep.shade.io.grpc.internal.GrpcUtil;
import org.hansken.ep.shade.io.grpc.stub.MetadataUtils;
import org.hansken.ep.shade.io.grpc.stub.StreamObserver;
import org.hansken.extraction.plugin.grpc.ExtractionPluginServiceGrpc;
import org.hansken.extraction.plugin.grpc.RpcPluginInfo;
import org.hansken.plugin.extraction.api.PluginInfo;
import org.hansken.plugin.extraction.api.TraceSearcher;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginDataReader;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginGrpcAdapter;
import org.hansken.plugin.extraction.runtime.grpc.client.ProtocolHandler;
import org.hansken.plugin.extraction.runtime.grpc.client.ReplyStream;
import org.hansken.plugin.extraction.runtime.grpc.client.RetryPolicy;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.hansken.plugin.extraction.runtime.grpc.client.api.RemoteExtractionPlugin;
import org.hansken.plugin.extraction.runtime.grpc.common.Unpack;
import org.hansken.plugin.extraction.runtime.grpc.common.VersionUtil;
import org.hansken.plugin.extraction.util.ArgChecks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractionPluginClient
implements RemoteExtractionPlugin,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractionPluginClient.class);
    private static final Empty EMPTY = Empty.getDefaultInstance();
    private static final int MAX_MESSAGE_SIZE = 0x4000000;
    private final ManagedChannel _channel;
    private final ExtractionPluginServiceGrpc.ExtractionPluginServiceBlockingStub _blockingPluginStub;
    private final ExtractionPluginServiceGrpc.ExtractionPluginServiceStub _asyncPluginStub;
    private final String _target;
    private RpcPluginInfo _pluginInfo;

    public ExtractionPluginClient(String host, int port) {
        this(GrpcUtil.authorityFromHostAndPort(host, port));
    }

    public ExtractionPluginClient(String host, int port, RetryPolicy retryPolicy) {
        this(GrpcUtil.authorityFromHostAndPort(host, port), retryPolicy);
    }

    public ExtractionPluginClient(String target) {
        this(target, null);
    }

    public ExtractionPluginClient(String target, RetryPolicy retryPolicy) {
        this(target, retryPolicy, "");
    }

    public ExtractionPluginClient(String target, RetryPolicy retryPolicy, String pluginId) {
        ArgChecks.argNotNull((String)"pluginId", (Object)pluginId);
        this._target = (String)ArgChecks.argNotNull((String)"target", (Object)target);
        Object builder = ((ManagedChannelBuilder)ManagedChannelBuilder.forTarget(target).usePlaintext()).maxInboundMessageSize(0x4000000);
        this._channel = retryPolicy == null ? ((ManagedChannelBuilder)builder).build() : ((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)builder).defaultServiceConfig(retryPolicy.toMethodConfigMap())).enableRetry()).maxRetryAttempts(retryPolicy.maxAttempts())).build();
        Metadata header = new Metadata();
        header.put(Metadata.Key.of("pluginId", Metadata.ASCII_STRING_MARSHALLER), pluginId);
        this._blockingPluginStub = (ExtractionPluginServiceGrpc.ExtractionPluginServiceBlockingStub)ExtractionPluginServiceGrpc.newBlockingStub(this._channel).withInterceptors(MetadataUtils.newAttachHeadersInterceptor(header));
        this._asyncPluginStub = (ExtractionPluginServiceGrpc.ExtractionPluginServiceStub)ExtractionPluginServiceGrpc.newStub(this._channel).withInterceptors(MetadataUtils.newAttachHeadersInterceptor(header));
    }

    @Override
    public boolean isCompatible() {
        String remotePluginVersion = this.getPluginApiVersion();
        return VersionUtil.isCompatible((String)remotePluginVersion);
    }

    public String getPluginApiVersion() {
        return Unpack.pluginApiVersion((RpcPluginInfo)this.getRpcPluginInfo());
    }

    public PluginInfo pluginInfo() {
        return Unpack.pluginInfo((RpcPluginInfo)this.getRpcPluginInfo());
    }

    private RpcPluginInfo getRpcPluginInfo() {
        if (this._pluginInfo == null) {
            this._pluginInfo = this._blockingPluginStub.pluginInfo(EMPTY);
        }
        return this._pluginInfo;
    }

    final void process(ClientTrace trace, ClientDataContext dataContext, TraceSearcher traceSearcher, ReplyStream replyStream) {
        ProtocolHandler protocolHandler = this.handler(trace, dataContext, traceSearcher, replyStream);
        StreamObserver<Any> responseSender = this._asyncPluginStub.process(protocolHandler);
        replyStream.init(responseSender);
        protocolHandler.start(trace, dataContext);
        protocolHandler.await();
    }

    @Override
    public void process(ClientTrace trace, ClientDataContext dataContext) throws IOException {
        this.processGrpcUnwrapped(() -> this.process(trace, dataContext, null, new ReplyStream()));
    }

    @Override
    public void processDeferred(ClientTrace trace, ClientDataContext dataContext, TraceSearcher searcher) throws IOException {
        this.processGrpcUnwrapped(() -> this.process(trace, dataContext, searcher, new ReplyStream()));
    }

    private void processGrpcUnwrapped(Runnable runnable) throws IOException {
        try {
            runnable.run();
        }
        catch (StatusRuntimeException e) {
            LOG.error("Got a gRPC StatusRuntimeException (status: " + e.getStatus() + "), logging this here, since the unwrapped exception is rethrown from here", (Throwable)e);
            throw this.unwrap(e);
        }
    }

    public String getTarget() {
        return this._target;
    }

    protected ProtocolHandler handler(ClientTrace trace, ClientDataContext dataContext, TraceSearcher searcher, ReplyStream stream) {
        return new ProtocolHandler(stream, this.adapter(trace, dataContext, searcher));
    }

    ConnectivityState getState() {
        return this._channel.getState(true);
    }

    protected ExtractionPluginGrpcAdapter adapter(ClientTrace trace, ClientDataContext dataContext, TraceSearcher searcher) {
        return new ExtractionPluginGrpcAdapter(trace, dataContext, new ExtractionPluginDataReader(dataContext), searcher);
    }

    @Override
    public void close() throws InterruptedException {
        this._channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
    }

    private RuntimeException unwrap(StatusRuntimeException e) throws IOException {
        if (e.getCause() == null) {
            throw e;
        }
        if (e.getCause() instanceof StatusRuntimeException) {
            return this.unwrap((StatusRuntimeException)e.getCause());
        }
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
        if (e.getCause() instanceof IOException) {
            throw (IOException)e.getCause();
        }
        if (e.getCause() instanceof Error) {
            throw (Error)e.getCause();
        }
        return new IllegalStateException(e.getCause());
    }
}

