package org.hansken.plugin.extraction.runtime.grpc.client;

/**
 * Used for exceptions thrown by the actual Extraction Plugins code.
 *
 * When the code of an Extraction Plugin throws an exception, the stacktrace is not
 * automatically shown in the logs. Instead a confusing gRPC StatusRuntimeException is shown. With
 * this class this StatusRuntimeException can be hidden. The relevant stacktrace is sent with
 * gRPC and can be printed in the logs.
 *
 * @author Netherlands Forensic Institute
 */
public class ExtractionPluginException extends RuntimeException {
    protected ExtractionPluginException(final String message,
                                        final Throwable cause,
                                        final boolean enableSuppression,
                                        final boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    /**
     * Get an instance of {@link ExtractionPluginException} that won't print its stacktrace.
     *
     * @param message The errormessage that will be printed.
     * @return an instance of {@link ExtractionPluginException} that won't print its stacktrace.
     */
    public static ExtractionPluginException getInstanceWithoutStacktrace(final String message) {
        return new ExtractionPluginException(message, null, true, false);
    }
}
