package org.hansken.plugin.extraction.runtime.grpc.client.api;

import org.hansken.plugin.extraction.api.DataContext;
import org.hansken.plugin.extraction.api.RandomAccessData;

/**
 * ClientDataContext with an added method to retrieve data for any trace. This is not available as part of the public API.
 * This is used on the Hansken client side to retrieve data.
 */
public interface ClientDataContext extends DataContext {
    /**
     * Retrieve data corresponding to the dataType of a specific trace.
     *
     * @param traceId id of the trace looking for data.
     * @param dataType datatype; e.g. raw, html.
     * @return randomaccessdata representing access to the provided data.
     */
    RandomAccessData data(String traceId, String dataType);
}
