/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hansken.extraction.plugin.grpc.RpcBatchUpdate;
import org.hansken.extraction.plugin.grpc.RpcBeginChild;
import org.hansken.extraction.plugin.grpc.RpcBeginDataStream;
import org.hansken.extraction.plugin.grpc.RpcEnrichTrace;
import org.hansken.extraction.plugin.grpc.RpcFinish;
import org.hansken.extraction.plugin.grpc.RpcFinishChild;
import org.hansken.extraction.plugin.grpc.RpcFinishDataStream;
import org.hansken.extraction.plugin.grpc.RpcRead;
import org.hansken.extraction.plugin.grpc.RpcSearchRequest;
import org.hansken.extraction.plugin.grpc.RpcTrace;
import org.hansken.extraction.plugin.grpc.RpcWriteDataStream;
import org.hansken.plugin.extraction.api.BatchSearchResult;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.api.SearchTrace;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.TraceSearcher;
import org.hansken.plugin.extraction.api.transformations.DataRange;
import org.hansken.plugin.extraction.api.transformations.DataTransformation;
import org.hansken.plugin.extraction.api.transformations.RangedDataTransformation;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginDataReader;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginGrpcAdapter;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.hansken.plugin.extraction.runtime.grpc.common.Pack;
import org.hansken.plugin.extraction.runtime.grpc.test.TestTrace;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

class ExtractionPluginGrpcAdapterTest {
    ExtractionPluginGrpcAdapterTest() {
    }

    @Test
    void saveDepthFirstPreOrder() throws IOException, ExecutionException, InterruptedException {
        AtomicInteger traceCount = new AtomicInteger();
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter((ClientTrace)TestTrace.emptyTrace().withOnSaveCallback(trace -> traceCount.incrementAndGet()), context, new ExtractionPluginDataReader(context));
        Message store = TransactionBuilder.create().beginChild("0-0", "1").beginChild("0-0-0", "2").beginChild("0-0-0-0", "4").finishChild("0-0-0-0").beginChild("0-0-0-1", "5").finishChild("0-0-0-1").finishChild("0-0-0").beginChild("0-0-1", "3").finishChild("0-0-1").finishChild("0-0").build();
        adapter.execute(Any.pack((Message)store));
        MatcherAssert.assertThat((Object)traceCount.get(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)5)));
    }

    @Test
    void enrichRootNoId() {
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter((ClientTrace)TestTrace.emptyTrace(), context, new ExtractionPluginDataReader(context));
        RpcEnrichTrace enrich = RpcEnrichTrace.newBuilder().setTrace(RpcTrace.newBuilder().build()).build();
        IllegalStateException error = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> ExtractionPluginGrpcAdapterTest.lambda$enrichRootNoId$1(adapter, (Message)enrich));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"id is expected to be 0, but instead is "));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"source:RpcEnrichTrace"));
    }

    @Test
    void enrichChild() throws IOException, ExecutionException, InterruptedException {
        AtomicReference child = new AtomicReference();
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter((ClientTrace)TestTrace.emptyTrace().withOnSaveCallback(child::set), context, new ExtractionPluginDataReader(context));
        Message store = TransactionBuilder.create().beginChild("0-0", "1").enrich("0-0", Set.of("file"), Map.of("file.name", "test"), List.of(new Trace.Tracelet("identity", List.of(new Trace.TraceletProperty("identity.id", (Object)"bla@blah.com")))), ExtractionPluginGrpcAdapterTest.createTransformations()).finishChild("0-0").build();
        adapter.execute(Any.pack((Message)store));
        MatcherAssert.assertThat((Object)((String)((Trace)child.get()).get("file.name")), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"test")));
        ExtractionPluginGrpcAdapterTest.assertTransformations(((TestTrace)child.get()).getTransformations());
    }

    @Test
    void enrichParent() throws IOException, ExecutionException, InterruptedException {
        TestTrace trace = (TestTrace)Mockito.spy((Object)TestTrace.emptyTrace());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{trace});
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter((ClientTrace)trace, context, new ExtractionPluginDataReader(context));
        Message store = TransactionBuilder.create().enrich("0", Set.of("file"), Map.of("file.name", "test"), List.of(new Trace.Tracelet("identity", List.of(new Trace.TraceletProperty("identity.id", (Object)"bla@blah.com")))), ExtractionPluginGrpcAdapterTest.createTransformations()).build();
        adapter.execute(Any.pack((Message)store));
        ((TestTrace)inOrder.verify((Object)trace)).setData((String)ArgumentMatchers.eq((Object)"raw"), (List<DataTransformation>)ArgumentMatchers.anyList());
        ((TestTrace)inOrder.verify((Object)trace)).addType((String)ArgumentMatchers.any());
        ((TestTrace)inOrder.verify((Object)trace)).set((String)ArgumentMatchers.any(), ArgumentMatchers.any());
        ((TestTrace)inOrder.verify((Object)trace)).addTracelet((Trace.Tracelet)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((String)trace.get("file.name")), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"test")));
        MatcherAssert.assertThat((Object)trace.traceletProperties().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        MatcherAssert.assertThat((Object)trace.traceletProperties().get(0).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"identity")));
        List value = trace.traceletProperties().get(0).getValue();
        MatcherAssert.assertThat((Object)value.size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        MatcherAssert.assertThat((Object)((Trace.TraceletProperty)value.get(0)).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"identity.id")));
        MatcherAssert.assertThat((Object)((Trace.TraceletProperty)value.get(0)).getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bla@blah.com")));
        ExtractionPluginGrpcAdapterTest.assertTransformations(trace.getTransformations());
    }

    @Test
    void enrichParentInScopeOfChild() throws IOException, ExecutionException, InterruptedException {
        TestTrace trace = (TestTrace)Mockito.spy((Object)TestTrace.emptyTrace());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{trace});
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter((ClientTrace)trace, context, new ExtractionPluginDataReader(context));
        Message store = TransactionBuilder.create().beginChild("0-0", "child1").enrich("0", Set.of("file"), Map.of("file.name", "test"), List.of(new Trace.Tracelet("identity", List.of(new Trace.TraceletProperty("identity.id", (Object)"bla@blah.com")))), ExtractionPluginGrpcAdapterTest.createTransformations()).finishChild("0-0").build();
        adapter.execute(Any.pack((Message)store));
        ((TestTrace)inOrder.verify((Object)trace)).newChild((String)ArgumentMatchers.any());
        ((TestTrace)inOrder.verify((Object)trace)).addType((String)ArgumentMatchers.any());
        ((TestTrace)inOrder.verify((Object)trace)).set((String)ArgumentMatchers.any(), ArgumentMatchers.any());
        ((TestTrace)inOrder.verify((Object)trace)).addTracelet((Trace.Tracelet)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)((String)trace.get("file.name")), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"test")));
        MatcherAssert.assertThat(trace.traceletProperties(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)trace.traceletProperties().get(0).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"identity")));
        List value = trace.traceletProperties().get(0).getValue();
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((Trace.TraceletProperty)value.get(0)).getName(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"identity.id")));
        MatcherAssert.assertThat((Object)((Trace.TraceletProperty)value.get(0)).getValue(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"bla@blah.com")));
        ExtractionPluginGrpcAdapterTest.assertTransformations(trace.getTransformations());
        MatcherAssert.assertThat(trace.children(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)trace.children().get(0).name(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"child1")));
    }

    @Test
    void saveRoot() {
        ClientTrace trace = (ClientTrace)Mockito.mock(ClientTrace.class);
        Mockito.when((Object)trace.newChild((String)ArgumentMatchers.any())).thenReturn((Object)trace);
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter(trace, context, new ExtractionPluginDataReader(context));
        Message store = TransactionBuilder.create().beginChild("0", "na-ah!").finishChild("0").build();
        IllegalStateException error = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> adapter.execute(Any.pack((Message)store)));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"id 0 is expected to be a direct child of 0, but it is not"));
    }

    @Test
    void saveChildForgettingFinish() {
        ClientTrace trace = (ClientTrace)Mockito.mock(ClientTrace.class);
        Mockito.when((Object)trace.newChild((String)ArgumentMatchers.any())).thenReturn((Object)trace);
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter(trace, context, new ExtractionPluginDataReader(context));
        Message store = TransactionBuilder.create().beginChild("0-0", "forget this").build();
        IllegalStateException error = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> adapter.execute(Any.pack((Message)store)));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"not all children have been finished"));
    }

    @Test
    void saveChildWithEmptyId() {
        ClientTrace trace = (ClientTrace)Mockito.mock(ClientTrace.class);
        Mockito.when((Object)trace.newChild((String)ArgumentMatchers.any())).thenReturn((Object)trace);
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter(trace, context, new ExtractionPluginDataReader(context));
        Message store = TransactionBuilder.create().beginChild("", "emptyId").finishChild("").build();
        Throwable error = Assertions.assertThrows(IllegalStateException.class, () -> adapter.execute(Any.pack((Message)store)));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"is expected to be"));
    }

    @Test
    void executeReadWithWrongTraceId() {
        ClientTrace trace = (ClientTrace)Mockito.mock(ClientTrace.class);
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter(trace, context, new ExtractionPluginDataReader(context));
        RpcRead store = RpcRead.newBuilder().setTraceUid("1").build();
        Throwable error = Assertions.assertThrows(NoSuchElementException.class, () -> ExtractionPluginGrpcAdapterTest.lambda$executeReadWithWrongTraceId$5(adapter, (Message)store));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"No data available for trace with uid"));
    }

    @Test
    void executeReadWithWrongDataType() {
        ClientTrace trace = (ClientTrace)Mockito.mock(ClientTrace.class);
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter(trace, context, new ExtractionPluginDataReader(context));
        RpcRead store = RpcRead.newBuilder().setTraceUid("0").setDataType("text").build();
        Throwable error = Assertions.assertThrows(NoSuchElementException.class, () -> ExtractionPluginGrpcAdapterTest.lambda$executeReadWithWrongDataType$6(adapter, (Message)store));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"No data available for data type"));
    }

    private ExtractionPluginGrpcAdapter setupSearchableAdapter(TestTrace[] foundTraces) throws InterruptedException, ExecutionException {
        ClientTrace trace = (ClientTrace)Mockito.mock(ClientTrace.class);
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        TraceSearcher searcher = (TraceSearcher)Mockito.mock(TraceSearcher.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        for (TestTrace foundTrace : foundTraces) {
            for (String dataType : foundTrace.getDataTypes()) {
                Mockito.when((Object)context.data((String)foundTrace.get("uid"), dataType)).thenReturn((Object)foundTrace.getData(dataType));
            }
        }
        BatchSearchResult result = new BatchSearchResult(100L);
        result.setTraces((SearchTrace[])foundTraces);
        Mockito.when((Object)searcher.search((String)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (TraceSearcher.SearchScope)ArgumentMatchers.any())).thenReturn((Object)result);
        return new ExtractionPluginGrpcAdapter(trace, context, new ExtractionPluginDataReader(context), searcher);
    }

    private void executeSearch(ExtractionPluginGrpcAdapter adapter) throws ExecutionException, InterruptedException, IOException {
        RpcSearchRequest search = RpcSearchRequest.newBuilder().setCount(1).setQuery("*").build();
        adapter.execute(Any.pack((Message)search));
    }

    @Test
    void testSearchTraceReadData() throws ExecutionException, InterruptedException, IOException {
        TestTrace trace1 = new TestTrace("result1");
        trace1.set("uid", "0-0").setData("html", writer -> writer.write(97));
        ExtractionPluginGrpcAdapter adapter = this.setupSearchableAdapter(new TestTrace[]{trace1});
        RpcRead read = RpcRead.newBuilder().setTraceUid("0-0").setDataType("html").build();
        Throwable error = Assertions.assertThrows(NoSuchElementException.class, () -> ExtractionPluginGrpcAdapterTest.lambda$testSearchTraceReadData$8(adapter, (Message)read));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"No data available for trace with uid: 0-0"));
        this.executeSearch(adapter);
        adapter.execute(Any.pack((Message)read));
    }

    @Test
    void testTraceReadDeprecatedData() throws ExecutionException, InterruptedException, IOException {
        ClientTrace trace = (ClientTrace)Mockito.mock(ClientTrace.class);
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter(trace, context, new ExtractionPluginDataReader(context));
        RpcRead read = RpcRead.newBuilder().setTraceId("0").setDataType("raw").build();
        adapter.execute(Any.pack((Message)read));
    }

    @Test
    void testSearchTraceReadDeprecatedData() {
        ClientTrace trace = (ClientTrace)Mockito.mock(ClientTrace.class);
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter(trace, context, new ExtractionPluginDataReader(context));
        RpcRead read = RpcRead.newBuilder().setTraceId("0:0").setDataType("raw").build();
        Throwable error = Assertions.assertThrows(IllegalStateException.class, () -> ExtractionPluginGrpcAdapterTest.lambda$testSearchTraceReadDeprecatedData$9(adapter, (Message)read));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"The Extraction Plugin SDK used to create your plugin is outdated. This version still uses the traceId field instead of traceUid to identify trace data. Update to at least 0.4.9."));
    }

    @Test
    void testSearchTraceReadWrongDataType() throws ExecutionException, InterruptedException, IOException {
        TestTrace trace1 = new TestTrace("result1");
        trace1.set("uid", "0-0").setData("html", writer -> writer.write(97));
        ExtractionPluginGrpcAdapter adapter = this.setupSearchableAdapter(new TestTrace[]{trace1});
        this.executeSearch(adapter);
        RpcRead read = RpcRead.newBuilder().setTraceUid("0-0").setDataType("raw").build();
        Throwable error2 = Assertions.assertThrows(NoSuchElementException.class, () -> ExtractionPluginGrpcAdapterTest.lambda$testSearchTraceReadWrongDataType$11(adapter, (Message)read));
        MatcherAssert.assertThat((Object)error2.getMessage(), (Matcher)Matchers.containsString((String)"No data available for data type"));
    }

    @Test
    void outOfOrderStreamingWrites() throws IOException, ExecutionException, InterruptedException {
        byte[] rootBytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] childBytes = new byte[]{10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
        ClientDataContext context = (ClientDataContext)Mockito.mock(ClientDataContext.class);
        Mockito.when((Object)context.dataType()).thenReturn((Object)"raw");
        Mockito.when((Object)context.data()).thenReturn((Object)((RandomAccessData)Mockito.mock(RandomAccessData.class)));
        TestTrace rootTrace = TestTrace.emptyTrace();
        ExtractionPluginGrpcAdapter adapter = new ExtractionPluginGrpcAdapter((ClientTrace)rootTrace, context, new ExtractionPluginDataReader(context));
        String rootTraceId = rootTrace.traceId();
        String childTraceId = "0-0";
        ExtractionPluginGrpcAdapterTest.packAndExecute(adapter, (Message)RpcBeginChild.newBuilder().setId("0-0").setName("baby shark").build());
        ExtractionPluginGrpcAdapterTest.packAndExecute(adapter, (Message)RpcBeginDataStream.newBuilder().setTraceId(rootTraceId).setDataType("raw").build());
        ExtractionPluginGrpcAdapterTest.packAndExecute(adapter, (Message)RpcBeginDataStream.newBuilder().setTraceId("0-0").setDataType("raw").build());
        assert (rootBytes.length == childBytes.length);
        for (int i = 0; i < rootBytes.length; ++i) {
            ExtractionPluginGrpcAdapterTest.packAndExecute(adapter, (Message)RpcWriteDataStream.newBuilder().setTraceId(rootTraceId).setDataType("raw").setData(ByteString.copyFrom((byte[])rootBytes, (int)i, (int)1)).build());
            ExtractionPluginGrpcAdapterTest.packAndExecute(adapter, (Message)RpcWriteDataStream.newBuilder().setTraceId("0-0").setDataType("raw").setData(ByteString.copyFrom((byte[])childBytes, (int)i, (int)1)).build());
        }
        ExtractionPluginGrpcAdapterTest.packAndExecute(adapter, (Message)RpcFinishDataStream.newBuilder().setTraceId(rootTraceId).setDataType("raw").build());
        ExtractionPluginGrpcAdapterTest.packAndExecute(adapter, (Message)RpcFinishDataStream.newBuilder().setTraceId("0-0").setDataType("raw").build());
        ExtractionPluginGrpcAdapterTest.packAndExecute(adapter, (Message)RpcFinishChild.newBuilder().setId("0-0").build());
        MatcherAssert.assertThat(rootTrace.children(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(rootTrace.dataStreams(), (Matcher)Matchers.hasKey((Object)"raw"));
        Assertions.assertArrayEquals((byte[])rootTrace.dataStreams().get("raw"), (byte[])rootBytes);
        TestTrace childTrace = rootTrace.children().get(0);
        MatcherAssert.assertThat(childTrace.dataStreams(), (Matcher)Matchers.hasKey((Object)"raw"));
        Assertions.assertArrayEquals((byte[])childTrace.dataStreams().get("raw"), (byte[])childBytes);
    }

    private static Optional<Any> packAndExecute(ExtractionPluginGrpcAdapter adapter, Message message) throws ExecutionException, InterruptedException, IOException {
        return adapter.execute(Any.pack((Message)message));
    }

    private static void assertTransformations(Map<String, List<DataTransformation>> transformations) {
        MatcherAssert.assertThat((Object)transformations.get("raw").size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2)));
        MatcherAssert.assertThat((Object)((DataRange)((RangedDataTransformation)transformations.get("raw").get(0)).getRanges().get(0)).getOffset(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        MatcherAssert.assertThat((Object)((DataRange)((RangedDataTransformation)transformations.get("raw").get(0)).getRanges().get(0)).getLength(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)2L)));
        MatcherAssert.assertThat((Object)((DataRange)((RangedDataTransformation)transformations.get("raw").get(0)).getRanges().get(1)).getOffset(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)3L)));
        MatcherAssert.assertThat((Object)((DataRange)((RangedDataTransformation)transformations.get("raw").get(0)).getRanges().get(1)).getLength(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)4L)));
        MatcherAssert.assertThat((Object)((DataRange)((RangedDataTransformation)transformations.get("raw").get(1)).getRanges().get(0)).getOffset(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)5L)));
        MatcherAssert.assertThat((Object)((DataRange)((RangedDataTransformation)transformations.get("raw").get(1)).getRanges().get(0)).getLength(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)6L)));
    }

    private static Map<String, List<DataTransformation>> createTransformations() {
        HashMap<String, List<DataTransformation>> transformations = new HashMap<String, List<DataTransformation>>();
        ArrayList<RangedDataTransformation> rangedTransformations = new ArrayList<RangedDataTransformation>();
        rangedTransformations.add(new RangedDataTransformation(new DataRange[]{new DataRange(1L, 2L), new DataRange(3L, 4L)}));
        rangedTransformations.add(new RangedDataTransformation(new DataRange[]{new DataRange(5L, 6L)}));
        transformations.put("raw", rangedTransformations);
        return transformations;
    }

    private static /* synthetic */ void lambda$testSearchTraceReadWrongDataType$11(ExtractionPluginGrpcAdapter adapter, Message read) throws Throwable {
        adapter.execute(Any.pack((Message)read));
    }

    private static /* synthetic */ void lambda$testSearchTraceReadDeprecatedData$9(ExtractionPluginGrpcAdapter adapter, Message read) throws Throwable {
        adapter.execute(Any.pack((Message)read));
    }

    private static /* synthetic */ void lambda$testSearchTraceReadData$8(ExtractionPluginGrpcAdapter adapter, Message read) throws Throwable {
        adapter.execute(Any.pack((Message)read));
    }

    private static /* synthetic */ void lambda$executeReadWithWrongDataType$6(ExtractionPluginGrpcAdapter adapter, Message store) throws Throwable {
        adapter.execute(Any.pack((Message)store));
    }

    private static /* synthetic */ void lambda$executeReadWithWrongTraceId$5(ExtractionPluginGrpcAdapter adapter, Message store) throws Throwable {
        adapter.execute(Any.pack((Message)store));
    }

    private static /* synthetic */ void lambda$enrichRootNoId$1(ExtractionPluginGrpcAdapter adapter, Message enrich) throws Throwable {
        adapter.execute(Any.pack((Message)enrich));
    }

    static final class TransactionBuilder {
        private final RpcBatchUpdate.Builder _update = RpcBatchUpdate.newBuilder();

        TransactionBuilder() {
        }

        static TransactionBuilder create() {
            return new TransactionBuilder();
        }

        TransactionBuilder beginChild(String id, String name) {
            this._update.addActions(Any.pack((Message)RpcBeginChild.newBuilder().setId(id).setName(name).build()));
            return this;
        }

        TransactionBuilder enrich(String id, Set<String> types, Map<String, Object> properties, List<Trace.Tracelet> tracelets, Map<String, List<DataTransformation>> transformations) {
            this._update.addActions(Any.pack((Message)Pack.traceEnrichment((String)id, types, properties, tracelets, transformations)));
            return this;
        }

        TransactionBuilder finishChild(String id) {
            this._update.addActions(Any.pack((Message)RpcFinishChild.newBuilder().setId(id).build()));
            return this;
        }

        Message build() {
            return this._update.addActions(Any.pack((Message)RpcFinish.getDefaultInstance())).build();
        }
    }
}

