/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.runtime.grpc.client.DataStreamTransferStateManager;
import org.hansken.plugin.extraction.runtime.grpc.test.TestTrace;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamTransferStateTest {
    private static final byte[] EMPTY = new byte[0];
    private final ExecutorService _executors = Executors.newCachedThreadPool();

    StreamTransferStateTest() {
    }

    @Test
    void writeWithoutSetup() {
        DataStreamTransferStateManager transfer = this.createTransfer((Trace)TestTrace.emptyTrace());
        Throwable error = Assertions.assertThrows(IllegalStateException.class, () -> transfer.get("raw").write(EMPTY));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"data stream transfer not started for datastream 'raw'"));
    }

    @Test
    void finishWithoutSetup() {
        DataStreamTransferStateManager transfer = this.createTransfer((Trace)TestTrace.emptyTrace());
        Throwable error = Assertions.assertThrows(IllegalStateException.class, () -> transfer.finish("raw"));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"data stream transfer not started for datastream 'raw'"));
    }

    @Test
    void shutdownWithoutSetup() {
        this.createTransfer((Trace)TestTrace.emptyTrace()).finishAll();
    }

    @Test
    void startTwice() throws IOException {
        DataStreamTransferStateManager transfer = this.createTransfer((Trace)TestTrace.emptyTrace());
        transfer.start("raw");
        Throwable error = Assertions.assertThrows(IllegalStateException.class, () -> transfer.start("raw"));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"data stream transfer started for data stream 'raw', but was already started"));
    }

    @Test
    void writeChunkOfWrongType() throws IOException {
        byte[] chunk = new byte[]{10, 11, 12};
        DataStreamTransferStateManager transfer = this.createTransfer((Trace)TestTrace.emptyTrace());
        transfer.start("raw");
        Throwable error = Assertions.assertThrows(IllegalStateException.class, () -> transfer.get("text").write(chunk));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"data stream transfer not started for datastream 'text'"));
    }

    @Test
    void closeWrongTypeOfStream() throws IOException {
        byte[] chunk = new byte[]{10, 11, 12};
        DataStreamTransferStateManager transfer = this.createTransfer((Trace)TestTrace.emptyTrace());
        transfer.start("raw");
        transfer.get("raw").write(chunk);
        Throwable error = Assertions.assertThrows(IllegalStateException.class, () -> transfer.finish("text"));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"data stream transfer not started for datastream 'text'"));
    }

    @Test
    void singleChunkTransfer() throws IOException {
        byte[] chunk = new byte[]{10, 11, 12};
        TestTrace trace = TestTrace.emptyTrace();
        DataStreamTransferStateManager transfer = this.createTransfer((Trace)trace);
        transfer.start("raw");
        transfer.get("raw").write(chunk);
        transfer.finish("raw");
        MatcherAssert.assertThat((Object)trace.dataStreams().get("raw"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)chunk)));
    }

    @Test
    void singleLargeChunkTransfer() throws IOException {
        byte[] chunk = new byte[0x2000000];
        new Random(0L).nextBytes(chunk);
        TestTrace trace = TestTrace.emptyTrace();
        DataStreamTransferStateManager transfer = this.createTransfer((Trace)trace);
        transfer.start("raw");
        transfer.get("raw").write(chunk);
        transfer.finish("raw");
        MatcherAssert.assertThat((Object)trace.dataStreams().get("raw"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)chunk)));
    }

    @Test
    void multiChunkTransfer() throws IOException {
        byte[] stream = new byte[]{1, 2, 3, 4, 5, 6};
        TestTrace trace = TestTrace.emptyTrace();
        DataStreamTransferStateManager transfer = this.createTransfer((Trace)trace);
        transfer.start("raw");
        transfer.get("raw").write(Arrays.copyOfRange(stream, 0, 3));
        transfer.get("raw").write(Arrays.copyOfRange(stream, 3, 6));
        transfer.finish("raw");
        MatcherAssert.assertThat((Object)trace.dataStreams().get("raw"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)stream)));
    }

    @Test
    void writeMultipleStreams() throws IOException {
        byte[] rawStream = new byte[]{1, 2, 3, 4, 5, 6};
        byte[] textStream = "yes!".getBytes(StandardCharsets.UTF_8);
        TestTrace trace = TestTrace.emptyTrace();
        DataStreamTransferStateManager transfer = this.createTransfer((Trace)trace);
        transfer.start("raw");
        transfer.get("raw").write(rawStream);
        transfer.finish("raw");
        transfer.start("text");
        transfer.get("text").write(textStream);
        transfer.finish("text");
        MatcherAssert.assertThat((Object)trace.dataStreams().get("raw"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)rawStream)));
        MatcherAssert.assertThat((Object)trace.dataStreams().get("text"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)textStream)));
    }

    private DataStreamTransferStateManager createTransfer(Trace trace) {
        return new DataStreamTransferStateManager(trace, this._executors);
    }
}

