package org.hansken.plugin.extraction.runtime.grpc.client;

import java.util.Map;

import org.hansken.extraction.plugin.grpc.RpcProfile;

/**
 * A plugin profile report from the plugin perspective.
 * <p>
 * Contains key/values for integers and doubles. Can be used by the plugin to report any kind of profile statistics,
 * such as: number of searchers, time it took for these searchers, number of bytes read, process()-duration, etc.
 */
public final class PluginRunProfile {
    private final Map<String, Long> _integers;
    private final Map<String, Double> _doubles;

    private PluginRunProfile(final Map<String, Long> integers, final Map<String, Double> doubles) {
        _integers = integers;
        _doubles = doubles;
    }

    /**
     * Constructs a {@link PluginRunProfile} from a {@link RpcProfile}.
     *
     * @param profile the original RpcProfile to convert
     * @return the {@link PluginRunProfile} representation of the input profile
     */
    public static PluginRunProfile of(final RpcProfile profile) {
        return new PluginRunProfile(profile.getProfileInt64SMap(), profile.getProfileDoublesMap());
    }

    /**
     * Returns all Long integers reported in the run profile.
     *
     * @return all long integers in the run profile
     */
    public Map<String, Long> getIntegers() {
        return _integers;
    }

    /**
     * Returns all Double floating points reported in the run profile.
     *
     * @return all long integers in the run profile
     */
    public Map<String, Double> getDoubles() {
        return _doubles;
    }
}
